package gov.va.med.esr.common.rule.service;

// Java classes
import java.io.Serializable;
import java.util.List;

// Library classes

// Framework classes
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.validation.ValidationMessages;

// ESR classes
import gov.va.med.esr.common.clock.Clock;
import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.comms.HandBookMailQueue;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.service.trigger.LetterTriggerEvent;
import gov.va.med.esr.service.IVMFinancialInfo;

/**
 * Project: Common
 * @author DNS   RUIZC
 * @version 1.0
 */
public interface CommunicationRuleService extends Serializable {
    /**
     * Handle the processing of undeliverable mail.
     * 
     * @param commsLogEntries
     * @throws ServiceException
     */
    public void handleUndeliverableMail(List  commsLogEntries) throws ServiceException;
    
   
    /**
     * Handle the processing of undeliverable handbook.
     * 
     * @param incoming The incoming HandBookMailQueue object
     * @throws ServiceException
     */
   public void handleUndeliverableHandbook(HandBookMailQueue incoming) throws ServiceException;
    	 
    /**
     * Process a letter send request from UI
     * 
     * @param person
     * @param formNumber
     * @param workflowCaseId
     * @param mailType
     * @param override
     * @param logs
     * @param categoryType
     * 
     * @return ValidationMessages
     * @throws ServiceException
     */
    public ValidationMessages processLetterSendRequest(Person person,
            ComLetterTemplateType formNumber, String workflowCaseId,
            LetterTriggerEvent.MailType mailType, Boolean override, List logs, String categoryType)
            throws ServiceException;
    

    /**
     * Method to executes rules dealing with comms log entry.
     * 
     * @param incoming
     * @param onFile
     * @throws ServiceException
     */
    public void manageCommunicationsLog(CommsLogEntry incoming, CommsLogEntry onFile) throws ServiceException;
    
   
    
    /**
     * Trigger letter for particular subject (person)
     * 
     * @param person
     * @param clockType
     * @param subject
     * @throws ServiceException
     */
    public void triggerAutomaticLetters(Person person, Clock.Type clockType, String subject) throws ServiceException;    
    

    /**
     * Trigger letter for IVM context request
     * 
     * @param person
     * @param info
     * @throws ServiceException
     */
    public void triggerAutomaticLetters(Person person, IVMFinancialInfo info) throws ServiceException;    
    
    /**
     * Trigger letters for a specific income year.
     *  
     * @param person
     * @param incomeYear
     * @param reviewOnly
     * @throws ServiceException
     */
    public void triggerAutomaticLetters(Person person, Integer incomeYear, boolean reviewOnly, Clock.Type clockType) throws ServiceException;    
    
  
    /**
     * Execute the handle mailing response rules.
     * 
     * @param responses
     * @throws ServiceException
     */
    public void  handleMailingResponses(List responses) throws ServiceException;
    
    public void  handleMailingResponses(CommsLogEntry incoming) throws ServiceException;
    
    public void  handleHandbookMailingResponse(HandBookMailQueue incoming) throws ServiceException;
    
}
