/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule.service;

//Java classes
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

// Library classes

// Framework classes
import gov.va.med.fw.service.ServiceException;

// EDB classes
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Person;

/**
 * Project: Common
 * @author DNS   LEV
 * @version 1.0
 */
public interface AssociationRuleService extends Serializable {
    
   /** Processes an association coming from a screen
    * @param incoming Incoming association either added or updated from a screen
    * @param onFile A person on file
    * @param incoming New/Updated association
    * @return an updated person to be saved in the database
    * @throws ServiceException In case of error processing association     
    */
    public Person manageAssociation(Association incoming, Person onFile ) throws ServiceException;
   
   /** Processes a collection of associations coming from a message
    * @param incoming Incoming associations either added or updated from a message
    * @param onFile A person on file
    * @throws ServiceException In case of error processing association
    */
   public void processAssociations( Set incoming, Person onFile ,VAFacility sendingFAcility ) throws ServiceException;

   public boolean processAssociations( boolean isVistA, Set incoming, Person onFile ,VAFacility sendingFAcility ) throws ServiceException;

   public void removeAssociations(Set associations, Person onFile, VAFacility sendingFacility) throws ServiceException;
   
   public void triggerZ05(VAFacility sendingFacility, Person updatedPerson) throws ServiceException;
   
   public boolean upddateAssociations(Set incoming, Person onFile, VAFacility sendingFacility) throws ServiceException;
}
