/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule.parameter;

// Java classes
import java.util.Date;
import gov.va.med.fw.service.ServiceException;

// Library classes

// Framework classes

// ESR Classes
import gov.va.med.esr.common.model.ee.MedicaidFactor;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.MedicaidInput;

/**
 * @author Carlos Ruiz
 * @version 1.0
 */
public class MedicaidInputParameter extends BaseParameter implements MedicaidInput {

    private static final long serialVersionUID = 1607147494117646390L;

    public MedicaidInputParameter() {
        super();
    }

    public MedicaidFactor getMedicaidFactor() {
        return this.getMedicaidFactor(this.getIncomingPerson());
    }
    
    public MedicaidFactor getResultMedicaidFactor() {
        return this.getMedicaidFactor(this.getResultPerson());
    }
    
    /**
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.common.rule.MedicaidInput#isEligibileForMedicaid()
     */
    public boolean isEligibleForMedicaid() {
        return this.isEligibleForMedicaid(this.getIncomingPerson());
    }
    
    /**
     * @see gov.va.med.esr.common.rule.parameter.MedicaidInput#getDateMedicaidLastUpdated()
     */
    public Date getDateMedicaidLastUpdated() {
        MedicaidFactor medicaidFactor = this.getMedicaidFactor(this
                .getIncomingPerson());
        return medicaidFactor != null ? medicaidFactor.getLastUpdateDate()
                : null;
    }
    
    public Date getResultDateMedicaidLastUpdated() {
        MedicaidFactor medicaidFactor = this.getMedicaidFactor(this
                .getResultPerson());
        return medicaidFactor != null ? medicaidFactor.getLastUpdateDate()
                : null;
    }    
    /**
     * @see gov.va.med.esr.common.rule.MedicaidInput#isResultEligibleForMedicaid()
     */
    public boolean isResultEligibleForMedicaid() {
   	 return this.isEligibleForMedicaid( this.getResultPerson() );
    }
    
    public void updateMedicaidFacotr()
    {
        MedicaidFactor incoming = getMedicaidFactor();
        
        if (incoming != null) {
            MedicaidFactor medicaidFactor = getResultMedicaidFactor();
            if (medicaidFactor == null) {
                medicaidFactor = new MedicaidFactor();
                this.getResultPerson().setMedicaidFactor(medicaidFactor);
                //
            }
            //TODO Handle the exception in proper way
            try {
            	getMergeRuleService().mergeMedicaidFactor(incoming, medicaidFactor); 
            }catch (ServiceException ex){
            	throw new RuntimeException(ex.getMessage(),ex);
            }
        }      
    }
    
    // CR 9803 and CCR 10023
    public boolean isEligibleForMedicaid(Person person) {
        MedicaidFactor medicaidFactor = this.getMedicaidFactor(person);
        return (medicaidFactor != null && medicaidFactor
                .isEligibleForMedicaid() != null) ? medicaidFactor
                .isEligibleForMedicaid().booleanValue() : false;
    }
    
    private MedicaidFactor getMedicaidFactor(Person person) {
        return (person != null) ? person.getMedicaidFactor() : null;
    }
    public boolean isEligibleForMedicaidChanged(){
    	MedicaidFactor incomingMedicaidFactor = this.getMedicaidFactor(this.getIncomingPerson());
    	MedicaidFactor PristineMedicaidFactor = this.getMedicaidFactor(this.getPristinePerson());
    	if(incomingMedicaidFactor !=null &&PristineMedicaidFactor !=null){
    	    	return !(this.isEqual(incomingMedicaidFactor, PristineMedicaidFactor));
    	}
    	else if(incomingMedicaidFactor==null &&PristineMedicaidFactor==null){
    		return false;
    	}
    	else if((incomingMedicaidFactor==null &&PristineMedicaidFactor!=null && PristineMedicaidFactor.getEligibleForMedicaid().booleanValue())||
    			(incomingMedicaidFactor!=null &&PristineMedicaidFactor==null && incomingMedicaidFactor.getEligibleForMedicaid().booleanValue())){
    	    return true;
    	}
    	else
    		return false;
    }
}