/*
 * Created on Feb 14, 2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.model.ee.FeeBasis;
import gov.va.med.esr.common.model.lookup.FeeBasisProgram;
import gov.va.med.esr.common.model.lookup.FeeBasisTreatmentType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.rule.FeeBasisProgramInput;
import gov.va.med.esr.common.rule.data.FeeBasisInputData;
import gov.va.med.esr.common.rule.data.PersonInputData;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.service.ServiceException;

import java.util.Date;

/**
 * 
 * @author DNS   SHARIA
 */
public class FeeBasisProgramInputParameter extends BaseParameter implements
		FeeBasisProgramInput {

	/**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = 4321239137297851646L;
      
   public FeeBasis getFeeBasis() {
        RuleDataAware ruleDataAware = this.getRuleDataAware();
        if (ruleDataAware instanceof FeeBasisInputData) {
            return ((FeeBasisInputData)ruleDataAware).getIncomingFeeBasis();
        }
        return null;
   }
   
   public FeeBasis getVeteranFeeBasis() {
       RuleDataAware ruleDataAware = this.getRuleDataAware();
       if (ruleDataAware instanceof FeeBasisInputData) {
           return ((FeeBasisInputData)ruleDataAware).getOnFileFeeBasis();
       }
       return null;
   }
    
    /**
	 * (non-Javadoc)
	 * @see gov.va.med.esr.common.rule.FeeBasisProgramInput#getFeeBasisProgram(gov.va.med.esr.common.model.person.Person)
	 */
    public FeeBasisProgram getFeeBasisProgram() {
        FeeBasis fb = getFeeBasis();
        FeeBasisProgram fbp = fb == null ? null : fb.getProgram();
        return fbp;
    }
    
    public FeeBasisProgram getVeteranFeeBasisProgram() {
        FeeBasis fb = getVeteranFeeBasis();
        FeeBasisProgram fbp = fb == null ? null : fb.getProgram();
        return fbp;
    }
	/**
	 *  (non-Javadoc)
	 * @see gov.va.med.esr.common.rule.FeeBasisProgramInput#getFeeBasisTreatmentTye(gov.va.med.esr.common.model.person.Person)
	 */
    public FeeBasisTreatmentType getFeeBasisTreatmentType() {
        FeeBasis fb = getFeeBasis();
        FeeBasisTreatmentType fbtt = fb == null ? null : fb.getTreatmentType();
        return fbtt;
    }
    
    public FeeBasisTreatmentType getVeteranFeeBasisTreatmentType() {
        FeeBasis fb = getVeteranFeeBasis();
        FeeBasisTreatmentType fbtt = fb == null ? null : fb.getTreatmentType();
        return fbtt;
    }    

	/**
	 *  (non-Javadoc)
	 * @see gov.va.med.esr.common.rule.FeeBasisProgramInput#getAuthorizationFromDate(gov.va.med.esr.common.model.person.Person)
	 */
    public Date getAuthorizationFromDate() {
        FeeBasis fb = getFeeBasis();
        Date fbAuthFromDate = fb == null ? null : fb.getAuthorizationFromDate();
        return fbAuthFromDate;
    }
    
    public Date getVeteranAuthorizationFromDate() {
        FeeBasis fb = getVeteranFeeBasis();
        Date fbAuthFromDate = fb == null ? null : fb.getAuthorizationFromDate();
        return fbAuthFromDate;
    }    

	/**
	 *  (non-Javadoc)
	 * @see gov.va.med.esr.common.rule.FeeBasisProgramInput#getAuthorizationToDate(gov.va.med.esr.common.model.person.Person)
	 */
    public Date getAuthorizationToDate() {
        FeeBasis fb = getFeeBasis();
        Date fbAuthToDate = fb == null ? null : fb.getAuthorizationToDate();
        return fbAuthToDate;
    }
    
    public Date getVeteranAuthorizationToDate() {
        FeeBasis fb = getVeteranFeeBasis();
        Date fbAuthToDate = fb == null ? null : fb.getAuthorizationToDate();
        return fbAuthToDate;
    }
    
	/**
	 *  (non-Javadoc)
	 * @throws ServiceException 
	 * @see gov.va.med.esr.common.rule.FeeBasisProgramInput#mergeFeeBasisProgram()
	 */
	public void mergeFeeBasisProgram() throws ServiceException {

		FeeBasis incomingFeeBasis = getFeeBasis();
		FeeBasis pristineFeeBasis = getVeteranFeeBasis();
		
		if (incomingFeeBasis != null) {
            if (pristineFeeBasis == null) {
                pristineFeeBasis = new FeeBasis();
            }
			getMergeRuleService().mergeFeeBasis(incomingFeeBasis, pristineFeeBasis);
            
            if (pristineFeeBasis.getEntityKey() == null){
                getResultPerson().addFeeBasis(pristineFeeBasis);
            }
		}
		else if (pristineFeeBasis != null) {
			getResultPerson().removeFeeBasis(pristineFeeBasis);
		}
	}

	public VAFacility getSendingFacility() {
        RuleDataAware ruleDataAware = this.getRuleDataAware();
        if (ruleDataAware != null && ruleDataAware instanceof PersonInputData) {
            PersonInputData data = (PersonInputData) ruleDataAware;
            return data.getSendingFacility();
        }
        return null;
    }
    
    public VAFacility getReportingFacility() { 
        FeeBasis feeBasis = getFeeBasis();
        return feeBasis == null ? null : feeBasis.getReportSite();
    }
}
