/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.rule.parameter;

// ESR Classes
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.rule.FacilityInput;
import gov.va.med.esr.common.rule.data.EventInputData;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.ee.ReceivedEnrollment;
/**
 * @author Carlos Ruiz
 * @version 1.0
 */
public class FacilityInputParameter extends BaseParameter implements FacilityInput {

	private static final long serialVersionUID = -3283617393492683415L;

	/**
	 * Default constructor
	 */
	public FacilityInputParameter() {
		super();
	}

	/**
	 * @see gov.va.med.esr.common.rule.FacilityInput#getSendingSite()
	 */
	public String getSendingSite() {
		Person incoming = this.getIncomingPerson();
		ReceivedEnrollment enrollment = incoming != null ? incoming.getReceivedEnrollment() : null;
		VAFacility site = enrollment != null ? enrollment.getFacilityReceived() : null;
		return site != null ? site.getStationNumber() : null;
	}

	/**
	 * @see gov.va.med.esr.common.rule.FacilityInput#getFacilitySendingMessage()
	 */
	public VAFacility getFacilitySendingMessage() {
        if (this.getRuleDataAware() instanceof EventInputData) {
            return ((EventInputData)this.getRuleDataAware()).getSendingFacility();
        }
		Person incoming = this.getIncomingPerson();
		ReceivedEnrollment enrollment = incoming != null ? incoming.getReceivedEnrollment() : null;
		return enrollment != null ? enrollment.getFacilityReceived() : null;
	}
}