/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.rule.parameter;

import java.util.HashSet;
import java.util.Set;

import org.apache.commons.lang.StringUtils;

import gov.va.med.esr.common.rule.ConsistencyCheckInput;
import gov.va.med.esr.common.rule.data.accessor.MessageTriggerAccessor;
import gov.va.med.esr.service.trigger.IncomeYearTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTriggerIdentity;
import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;
import gov.va.med.fw.hl7.segment.IN1;
import gov.va.med.fw.hl7.segment.ZMT;

/**
 * Initial javadoc for class ConsistencyCheckInputParameter. TODO - Add content
 * here
 * 
 * Created Aug 8, 2006 12:01:35 PM
 * 
 * @author DNS   BOHMEG
 */
public class ConsistencyCheckInputParameter extends BaseParameter implements
		ConsistencyCheckInput {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 3613165189362610469L;

	public boolean isMessageTypeEqual(String messageTypeCode) {
		return getMessageTypeCode().equals(messageTypeCode);
	}

	private MessageTriggerAccessor getMessageTriggerAccessor() {
		return getRuleDataAware() instanceof MessageTriggerAccessor ? (MessageTriggerAccessor) getRuleDataAware()
				: null;
	}

	/**
	 * @return Returns the messageType.
	 */
	public String getMessageTypeCode() {
		MessageTriggerAccessor data = getMessageTriggerAccessor();
		if (data == null)
			return null;

		return (data.getMessageType(null) != null) ? data.getMessageType(null)
				.getCode() : null;
	}

	private PersonTriggerEvent getTriggerEvent() {
		MessageTriggerAccessor data = getMessageTriggerAccessor();
		if (data == null)
			return null;

		return data.getTriggerEvent(null);
	}

	private Message getMessage() {
		MessageTriggerAccessor data = getMessageTriggerAccessor();
		if (data == null)
			return null;

		return data.getMessage(null);
	}

	private Segment getSegment(String segmentName) {
		Segment segment = null;
		Message message = getMessage();
		if (message == null)
			return null;

		try {
			segment = message.getSegment(segmentName);
		} catch (InvalidMessageException e) {
			// do nothing
		}
		return segment;
	}

	public Integer getTriggerEventIncomeYear() {
		PersonTriggerEvent triggerEvent = getTriggerEvent();
		if (triggerEvent == null)
			return null;

		return (triggerEvent instanceof IncomeYearTriggerEvent) ? ((IncomeYearTriggerEvent) triggerEvent)
				.getIncomeYear()
				: null;
	}

	public boolean isTriggerEventDataTypeEqualTo(
			String personTriggerIdentityDataTypeCode) {
		PersonTriggerEvent triggerEvent = getTriggerEvent();
		if (triggerEvent == null)
			return false;

		Set applicableDataTypes = new HashSet(1);
		applicableDataTypes.add(PersonTrigger.DataType
				.getDataType(personTriggerIdentityDataTypeCode));
		// use all same values except DataType
		PersonTriggerIdentity triggerIdentity = (PersonTriggerIdentity) triggerEvent
				.getTriggerIdentity();
		PersonTriggerIdentity matchingIdentity = new PersonTriggerIdentity(
				triggerIdentity);
		matchingIdentity.setApplicableDataTypes(applicableDataTypes);

		return (triggerEvent != null) ? ((PersonTriggerIdentity) triggerEvent
				.getTriggerIdentity()).matchTriggerCriteria(matchingIdentity)
				: false;
	}

	private IN1 getIN1Segment() {
		return (IN1) getSegment(SegmentConstants.IN1);
	}

	private ZMT getZMTSegment() {
		return (ZMT) getSegment(SegmentConstants.ZMT);
	}
	
	private String standardizeSegmentValueForCC(String val) {
		// regardless what Segment does, we want null for the CCs
		return StringUtils.isBlank(val) ? null : val;
	}
	
	public String getZ04InsuranceCompanyName() {
		IN1 segment = getIN1Segment();
		if (segment == null)
			return null;

		return standardizeSegmentValueForCC(segment.getInsuranceCompanyName());
	}
	
	public String getZ04InsuranceGroupNumber() {
		IN1 segment = getIN1Segment();
		if (segment == null)
			return null;

		return standardizeSegmentValueForCC(segment.getGroupNumber());
	}

	public String getZ04InsuranceRelationshipToPatient() {
		IN1 segment = getIN1Segment();
		if (segment == null)
			return null;

		return standardizeSegmentValueForCC(segment.getInsuredRelationToPatient());
	}

	public String getZ04NameOfInsured() {
		IN1 segment = getIN1Segment();
		if (segment == null)
			return null;

		return standardizeSegmentValueForCC(segment.getInsuredName());
	}
	
	public String getZ06MeansTestDate() {
		ZMT segment = getZMTSegment();
		if (segment == null)
			return null;

		return standardizeSegmentValueForCC(segment.getMeansTestDate());
	}	

	public String getZ06DateVeteranSignedMeansTest() {
		ZMT segment = getZMTSegment();
		if (segment == null)
			return null;

		return standardizeSegmentValueForCC(segment.getVeteranTestSignedDate());
	}
}
