/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.rule.parameter;

// Java classes
import java.util.HashSet;
import java.util.Set;

// Library classes

// Framework classes
import gov.va.med.fw.service.trigger.TriggerEvent;

// ESR classes
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;

/**
 * Implements methods needed to trigger an event 
 *
 * Project: Common</br>
 * Created on: 10:55:28 PM </br>
 *
 * @author DNS   LEV
 */
public class AbstractTriggerAwareInputParameter extends BaseParameter	implements PersonTrigger {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 899492107812831282L;

   /**
    * An instance of triggerEvents
    */
   private Set triggerEvents = new HashSet();
   
	/**
	 * A default constructor
	 */
	public AbstractTriggerAwareInputParameter() {
		super();
	}

	/**
	 * @see gov.va.med.fw.service.trigger.TriggerAware#getTriggerEvents()
	 */
	public Set getTriggerEvents() {
		return triggerEvents;
	}

	/**
	 * @see gov.va.med.esr.service.trigger.PersonTrigger#getPersonId()
	 */
	public PersonEntityKey getPersonId() {
		return this.getResultPerson() != null ? (PersonEntityKey) this.getResultPerson().getEntityKey() : null;
	}

	/**
	 * @see gov.va.med.esr.service.trigger.PersonTrigger#getPersonId()
	 */
	public PersonIdentityTraits getPersonIdentityTraits() {
		return this.getResultPerson() != null ? this.getResultPerson().getIdentityTraits() : null;
	}
	
	/**
	 * @see gov.va.med.fw.service.trigger.TriggerAware#addTriggerEvent(gov.va.med.fw.service.trigger.TriggerEvent)
	 */
	public void addTriggerEvent(TriggerEvent triggerEvent) {
		if(! (triggerEvent instanceof PersonTriggerEvent))
			throw new IllegalArgumentException("Only Person TriggerEvent's are supported");
		
        ((PersonTriggerEvent) triggerEvent).setPersonId(getPersonId());
        ((PersonTriggerEvent) triggerEvent).setIdentityTraits(getPersonIdentityTraits());
		boolean firstTimeAdded = triggerEvents.add(triggerEvent);
		if(!firstTimeAdded) {
			if(logger.isWarnEnabled())
				logger.warn("Ignoring duplicate of TriggerEvent: " + triggerEvent);
		}
	}

	/**
	 * @see gov.va.med.fw.service.trigger.TriggerAware#clearTriggerEvents()
	 */
	public void clearTriggerEvents() {
		triggerEvents.clear();		
	}
}