/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.rule.data.accessor;

import org.apache.commons.lang.enums.Enum;

/**
 * Initial javadoc for class PropertyAccessor.
 * TODO - Add content here
 * 
 * Created Aug 23, 2006 3:57:18 PM
 * @author DNS   BOHMEG
 */
public interface PropertyAccessor {
	public class DataType extends Enum {
		private static final long serialVersionUID = -3062036692887262708L;
        
        public static final DataType INCOMING = new DataType("INCOMING");
		public static final DataType PRISTINE = new DataType("PRISTINE");
		public static final DataType RESULT = new DataType("RESULT");
		private DataType(String name) { super(name); }
		
		public boolean isIncoming() {
			return INCOMING.getName().equals(getName());
		}
		public boolean isPristine() {
			return PRISTINE.getName().equals(getName());
		}
		public boolean isResult() {
			return RESULT.getName().equals(getName());
		}		
	} 
}
