/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.rule.data;

// Java classes

// Library classes

// Framework classes
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.person.Person;

/**
 * @author Ghazenfer Mansoor
 * @version 1.0
 */
public class SpouseFinancialsInputData extends FinancialInputData {
	
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -4095750110652850750L;

	private SpouseFinancials incomingSpouseFinancials = null;

    public SpouseFinancialsInputData(SpouseFinancials incomingSpouseFinancials,
            Person incoming,Person onFile,boolean isDemographicUpdate) 
    {
        setIncomingSpouseFinancials(incomingSpouseFinancials);
        this.setIncomingData(incoming);
        this.setResultData(onFile);
        this.setDemographicUpdate(isDemographicUpdate);
    }
    
	public SpouseFinancials getIncomingSpouseFinancials() {
		return incomingSpouseFinancials;
	}

	public void setIncomingSpouseFinancials(
			SpouseFinancials incomingSpouseFinancials) {
		this.incomingSpouseFinancials = incomingSpouseFinancials;
	}
}