package gov.va.med.esr.common.rule.data;

import gov.va.med.esr.common.batchprocess.SSASSNVerificationData;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Relation;

/**
 * 
 * @author Rajiv Patnaik Created on Mar 17, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class SSNVerificationResponseInputData extends BaseData
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 2932392301563118901L;
	private SSASSNVerificationData resultSSNVerificationData;
    
    private Relation relation;

    public Relation getRelation() {
        return relation;
    }

    public void setRelation(Relation relation) {
        this.relation = relation;
    }

    public SSNVerificationResponseInputData(SSASSNVerificationData incoming,
            Person result, Person pristine,SSASSNVerificationData outputData, Relation relation)
    {
        this.setIncomingData(incoming);
        this.setResultData(result);
        this.setResultSSNVerificationData(outputData);
        this.setPristineData(pristine);
        this.setRelation(relation);
    }

    /**
     * @return Returns the resultSSNVerificationData.
     */
    public SSASSNVerificationData getResultSSNVerificationData()
    {
        return resultSSNVerificationData;
    }

    /**
     * @param resultSSNVerificationData
     *            The resultSSNVerificationData to set.
     */
    public void setResultSSNVerificationData(
            SSASSNVerificationData resultSSNVerificationData)
    {
        this.resultSSNVerificationData = resultSSNVerificationData;
    }
}