/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule.data;

import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.rule.SimpleRuleDataAware;

// ESR classes
import gov.va.med.esr.common.model.ee.Document;
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.esr.service.LoadRegistryResult;

/**
 * Input data class for registry rule service.
 * 
 * @author Muddaiah Ranga
 * @version 1.0
 */
public class RegistryInputData extends SimpleRuleDataAware {
    
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 2976987929345504267L;
	private boolean isDataFromGUI = false;
    private Document document = null;
    private boolean exactMatchSameEpisode = false;            
    private boolean ambiguousMatch = false;
    private boolean exactMatch = false;    
    private boolean exactMatchDifferentEpisode = false; 
    private LoadRegistryResult loadRegistryResult = null; 
    private Person incomingPerson = null;
    private Person resultPerson = null;
    private RegistryType registryType=null;
    
    public RegistryInputData(Registry registry, boolean isDataFromGUI,RegistryType registryType) {
        super();        
        this.setIncomingData((AbstractEntity)registry);
        this.setDataFromGUI(isDataFromGUI);
        this.setRegistryType(registryType);
    }
    
    public RegistryInputData(Registry registry, Document document, boolean isDataFromGUI,RegistryType registryType) {
        super();        
        this.setIncomingData((AbstractEntity)registry);
        this.setDocument(document);
        this.setDataFromGUI(isDataFromGUI);
        this.setRegistryType(registryType);
    }
    
    public RegistryInputData(Registry incoming, Registry result, Registry pristine, boolean isDataFromGUI,RegistryType registryType) {
        super();
        this.setIncomingData((AbstractEntity)incoming);
        this.setResultData((AbstractEntity)result);  
        this.setPristineData((AbstractEntity)pristine);
        this.setDataFromGUI(isDataFromGUI);
        this.setRegistryType(registryType);
    }

    public RegistryInputData(Registry incoming, Registry result, Registry pristine, Person incomingPerson , Person onFilePerson, RegistryType registryType, boolean isDataFromGUI) {
        super();
        //Incoming registry can be null for the link use-case.
        if(incoming != null) {
            this.setIncomingData((AbstractEntity)incoming);
        }
        this.setResultData((AbstractEntity)result);
        this.setPristineData((AbstractEntity)pristine); 
        this.setIncomingPerson(incomingPerson);
        this.setResultPerson(onFilePerson);
        this.setRegistryType(registryType);
        this.setDataFromGUI(isDataFromGUI);
    }
    
    /**
     * @return Returns the isDataFromGUI.
     */
    public boolean isDataFromGUI() {
        return isDataFromGUI;
    }

    /**
     * @param isDataFromGUI The isDataFromGUI to set.
     */
    public void setDataFromGUI(boolean isDataFromGUI) {
        this.isDataFromGUI = isDataFromGUI;
    }

    public Document getDocument() {
        return document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    /**
     * @return Returns the ambiguousMatch.
     */
    public boolean isAmbiguousMatch() {
        return ambiguousMatch;
    }

    /**
     * @param ambiguousMatch The ambiguousMatch to set.
     */
    public void setAmbiguousMatch(boolean ambiguousMatch) {
        this.ambiguousMatch = ambiguousMatch;
    }

    /**
     * @return Returns the exactMatchDifferentEpisode.
     */
    public boolean isExactMatchDifferentEpisode() {
        return exactMatchDifferentEpisode;
    }

    /**
     * @param exactMatchDifferentEpisode The exactMatchDifferentEpisode to set.
     */
    public void setExactMatchDifferentEpisode(boolean exactMatchDifferentEpisode) {
        this.exactMatchDifferentEpisode = exactMatchDifferentEpisode;
    }

    /**
     * @return Returns the exactMatchSameEpisode.
     */
    public boolean isExactMatchSameEpisode() {
        return exactMatchSameEpisode;
    }

    /**
     * @param exactMatchSameEpisode The exactMatchSameEpisode to set.
     */
    public void setExactMatchSameEpisode(boolean exactMatchSameEpisode) {
        this.exactMatchSameEpisode = exactMatchSameEpisode;
    }

    /**
     * @return Returns the loadRegistryResult.
     */
    public LoadRegistryResult getLoadRegistryResult() {
        return loadRegistryResult;
    }

    /**
     * @param loadRegistryResult The loadRegistryResult to set.
     */
    public void setLoadRegistryResult(LoadRegistryResult loadRegistryResult) {
        this.loadRegistryResult = loadRegistryResult;
    }

    /**
     * Returns list if registies.
     * @return
     */
    public RegistryType getRegistryTytpe() {
        return this.registryType;
    }
    
    public void setRegistryType(RegistryType registryType){
    	this.registryType = registryType;
    }
    /**
     * @return Returns the exactMatch.
     */
    public boolean isExactMatch() {
        return exactMatch;
    }

    /**
     * @param exactMatch The exactMatch to set.
     */
    public void setExactMatch(boolean exactMatch) {
        this.exactMatch = exactMatch;
    }

    public Person getIncomingPerson() {
        return incomingPerson;
    }

    public void setIncomingPerson(Person incomingPerson) {
        this.incomingPerson = incomingPerson;
    }

    public Person getResultPerson() {
        return resultPerson;
    }

    public void setResultPerson(Person resultPerson) {
        this.resultPerson = resultPerson;
    }
}
