package gov.va.med.esr.common.rule.data;

// Java classes

// Library classes

// Framework classes

// ESR classes
import gov.va.med.esr.common.model.person.SignatureImage;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;

/**
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class PersonSignatureInputData extends PersonInputData {

    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 4662551054472151924L;

	private SignatureImage signatureImage = null;
    
    private Integer incomeYear = null;
    
    private String dfn = null;

    public PersonSignatureInputData(Person incoming, Person result,
            Person pristine, SignatureImage signatureImage, boolean isUpdateFromGUI) {
        super(incoming, result, pristine, isUpdateFromGUI);

        this.setSignatureImage(signatureImage);
    }

    public PersonSignatureInputData(Person incoming, Person result,
            Person pristine, SignatureImage signatureImage, VAFacility primaryAssessmentFacility, Integer incomeYear, boolean isUpdateFromGUI) {
        super(incoming, result, pristine, primaryAssessmentFacility, isUpdateFromGUI);
        
        this.setSignatureImage(signatureImage);
        this.setIncomeYear(incomeYear);
    }

    /**
     * @return Returns the signatureImage.
     */
    public SignatureImage getSignatureImage() {
        return signatureImage;
    }

    /**
     * @param signatureImage The signatureImage to set.
     */
    public void setSignatureImage(SignatureImage signatureImage) {
        this.signatureImage = signatureImage;
    }

    /**
     * @return Returns the primary assessment facility
     */
    public VAFacility getPrimaryAssessmentFacility() {
        return super.getSendingFacility();
    }

    /**
     * @param signatureImage The primary assessment facility to set.
     */
    public void setprimaryAssessmentFacility(VAFacility primaryAssessmentFacility) {
        super.setSendingFacility(primaryAssessmentFacility);
    }

    /**
     * @return Returns the incomeYear.
     */
    public Integer getIncomeYear() {
        return incomeYear;
    }

    /**
     * @param incomeYear The incomeYear to set.
     */
    public void setIncomeYear(Integer incomeYear) {
        this.incomeYear = incomeYear;
    }

    /**
     * @return Returns the dfn.
     */
    public String getDfn() {
        return dfn;
    }

    /**
     * @param dfn The dfn to set.
     */
    public void setDfn(String dfn) {
        this.dfn = dfn;
    }    
}
