/*****************************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ****************************************************************************************/
package gov.va.med.esr.common.rule.data;

// Java classes

// Library classes

// Framework classes

// EDB classes
import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.data.accessor.PropertyAccessor;
import gov.va.med.esr.service.PersonService;

/**
 * Project: Common
 * 
 * @author DNS   LEV
 * @version 1.0
 */
public class PersonInputData extends BaseData {
   /**
    * An instance of serialVersionUID
    */
   private static final long serialVersionUID = -6938028049650005752L;

   /**
    * An instance of isUpdateFromGUI
    */
   private boolean isUpdateFromGUI = false;

   /**
    * An instance of verificationInfo
    */
   private VerificationInfo verificationInfo = null;

   /**
    * An instance of personService 
    */
   private PersonService personService = null;
   /**
    * An instance of  handBookTrigger
    */
   private boolean handBookTrigger=false;

   public PersonInputData() {
	   
   }
   
   /**
    * A default constructor
    */
   public PersonInputData(Person incoming) {
      super(incoming);
   }

   /**
    * A default constructor
    */
   public PersonInputData(Person incoming, boolean isUpdateFromGUI) {
      super(incoming);

      this.setUpdateFromGUI(isUpdateFromGUI);
   }

   /**
    * A default constructor
    */
   public PersonInputData(Person incoming, Person result, boolean isUpdateFromGUI) {
      super(incoming, result);

      this.setUpdateFromGUI(isUpdateFromGUI);
   }

   public PersonInputData(Person incoming, Person result) {
	      super(incoming, result);
	   }
   
   /**
    * A default constructor
    */
   public PersonInputData(Person incoming, Person result, Person pristine,
         boolean isUpdateFromGUI) {
      super(incoming, result, pristine);

      this.setUpdateFromGUI(isUpdateFromGUI);
   }

   public PersonInputData(Person incoming, Person result, Person pristine,
         VAFacility sendingFacility, boolean isUpdateFromGUI) {
      super(incoming, result, pristine);
      this.setSendingFacility(sendingFacility);
      this.setUpdateFromGUI(isUpdateFromGUI);
   }

   /**
    * Use for messages that require sending facility and verification info
    * 
    * @param incoming
    * @param result
    * @param pristine
    * @param sendingFacility
    * @param info
    */
   public PersonInputData(Person incoming, Person result, Person pristine,
         VAFacility sendingFacility, VerificationInfo info) {
      this(incoming, result, pristine, false);
      this.setSendingFacility(sendingFacility);
      this.setVerificationInfo(info);
   }

   /**
    * A default constructor
    */
   public PersonInputData(Person incoming, Person result, Person pristine) {
      this(incoming, result, pristine, false);
   }

   /**
    * A default constructor
    */
   public PersonInputData(Person incoming, Person result, Person pristine,
         boolean isUpdateFromGUI, VerificationInfo info) {
      this(incoming, result, pristine, isUpdateFromGUI);
      this.setVerificationInfo(info);
   }

   /**
    * A default constructor
    */
   public PersonInputData(Person incoming, Person result, Person pristine,
         VerificationInfo info) {
      this(incoming, result, pristine, false);
      this.setVerificationInfo(info);
   }
   
   /**
    * A default constructor -- new
    */
   public PersonInputData(Person incoming, Person result, Person pristine,
         boolean isUpdateFromGUI, VAFacility sendingFacility, VerificationInfo info) {
      this(incoming, result, pristine, isUpdateFromGUI);
      this.setSendingFacility(sendingFacility);
      this.setVerificationInfo(info);
   }


   /**
    * A default constructor -- new 
	* Modified by Nixon
    
   public PersonInputData(Person incoming, Person result, Person pristine,
          VAFacility sendingFacility, boolean isUpdateFromGUI,VerificationInfo info) {
      this(incoming, result, pristine, isUpdateFromGUI);
      this.setSendingFacility(sendingFacility);
      this.setVerificationInfo(info);
   }
   */
   public PersonInputData(Person incoming, Person result, Person pristine,
		   VAFacility sendingFacility, boolean isUpdateFromGUI, boolean isUpdateFromMVI) {
	   super(incoming, result, pristine);
	   this.setSendingFacility(sendingFacility);
	   this.setUpdateFromGUI(isUpdateFromGUI);
	   this.setDataFromMVI(isUpdateFromMVI);
   }


   /**
    * @return A person that is pristine from the database
    */
   public Person getPristinePerson() {
      return (Person)this.getPristineData();
   }

   /**
    * @return A peson that is currently being updated
    */
   public Person getResultPerson() {
      return (Person)this.getResultData();
   }

   /**
    * @return A person that is built from incoming data
    */
   public Person getIncomingPerson() {
      return (Person)this.getIncomingData();
   }

   /**
    * @return Returns the isUpdateFromGUI.
    */
   public boolean isUpdateFromGUI() {
      return isUpdateFromGUI;
   }

   /**
    * @param isUpdateFromGUI
    *           The isUpdateFromGUI to set.
    */
   public void setUpdateFromGUI(boolean isUpdateFromGUI) {
      this.isUpdateFromGUI = isUpdateFromGUI;
   }

   /**
    * @return Returns the verificationInfo.
    */
   public VerificationInfo getVerificationInfo() {
      return verificationInfo;
   }

   /**
    * @param verificationInfo
    *           The verificationInfo to set.
    */
   public void setVerificationInfo(VerificationInfo verificationInfo) {
      this.verificationInfo = verificationInfo;
   }

   /**
    * Returns an instance of personService
    * @return PersonService personService.
    */
   public PersonService getPersonService() {
      return personService;
   }

   /**
    * Sets the personService of type PersonService
    * @param personService The personService to set.
    */
   public void setPersonService(PersonService personService) {
      this.personService = personService;
   }
   /**
    * @return Returns the handBookTrigger.
    */
   public boolean getHandBookTrigger() {
      return handBookTrigger;
   }

   /**
    * @param handBookTrigger
    *           The handBookTrigger to set.
    */
   public void setHandBookTrigger(boolean handBookTrigger) {
      this.handBookTrigger = handBookTrigger;
   }   
   
   protected Person getPerson(PropertyAccessor.DataType dataType) {	   	   
	   Person person = null;
	   if(dataType == null)
		   person = getPristinePerson(); // default	   
	   else if(dataType.isIncoming())
		   person = getIncomingPerson();
	   else if(dataType.isPristine())
		   person = getPristinePerson();
	   else if(dataType.isResult())
		   person = getResultPerson();
	   
	   return person;
   }
   
}