package gov.va.med.esr.common.rule.data;

// Java classes

// Library classes

// Framework classes

// ESR classes
import gov.va.med.esr.common.model.ee.POWEpisode;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;

/**
 * Project: Common
 * 
 * @author DNS   RUIZC
 * @version 1.0
 */
public class POWInputData extends PersonInputData {

    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 819394207908242196L;
	private POWEpisode powEpisode = null;

    /**
     * Constructor for validation
     * 
     * @param powEpisode
     * @param incoming
     * @param isUpdateFromGUI
     */
    public POWInputData(POWEpisode powEpisode, Person incoming, boolean isUpdateFromGUI) {
        super(incoming, isUpdateFromGUI);
        
        this.setPowEpisode(powEpisode);
    }

    /**
     * Constructor for manage/process POW
     * 
     * @param incoming
     * @param result
     * @param pristine
     * @param isUpdateFromGUI
     */
    public POWInputData(Person incoming, Person result, Person pristine, boolean isUpdateFromGUI) {
        super(incoming, result, pristine, isUpdateFromGUI);
    }
    /**
     * Constructor for manage/process POW
     * 
     * @param incoming
     * @param result
     * @param pristine
     * @param isUpdateFromGUI
     * @param sendingFacility
     */
    public POWInputData(Person incoming, Person result, Person pristine, boolean isUpdateFromGUI, VAFacility sendingFacility) {
        super(incoming, result, pristine, sendingFacility, isUpdateFromGUI);
    }

    /**
     * @return Returns the powEpisode.
     */
    public POWEpisode getPowEpisode() {
        return powEpisode;
    }

    /**
     * @param powEpisode The powEpisode to set.
     */
    public void setPowEpisode(POWEpisode powEpisode) {
        this.powEpisode = powEpisode;
    }

  
}
