/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.rule.data;

import java.util.HashSet;
import gov.va.med.esr.common.batchprocess.LoadVSSCDataResult;
import gov.va.med.esr.common.model.ee.AbstractCombatEpisode;
import gov.va.med.esr.common.model.ee.Activation;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.ee.CombatService;
import gov.va.med.esr.common.model.ee.ConflictExperience;
import gov.va.med.esr.common.model.ee.Deployment;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.infra.ImpreciseDate;

/**
 * This class is used to provide data for MilitaryService rules
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class MilitaryServiceInputData extends BaseData {
	
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -1142112890692935915L;

	// These codes map to work items that MSDS rules will generate
	public static final String WORKITEM_SUC1013_6_13_C = "01";
	public static final String WORKITEM_SUC1013_6_13_F = "02";
	public static final String WORKITEM_SUC1013_6_14_C = "03";	
	public static final String WORKITEM_SUC1013_6_15 = "04";	
	// Skipped 05
	public static final String WORKITEM_SUC1013_6_6G2 = "06";
	public static final String WORKITEM_SUC1013_6_6H3 = "07";
	public static final String WORKITEM_5_1_6_1NullValues = "08";
	public static final String WORKITEM_5_1_6_1NullValuesActivation = "09";
	public static final String WORKITEM_5_1_6_1NullValuesCombatPay = "10";	
	public static final String WORKITEM_5_1_6_1NullValuesDeployment = "11";	
	public static final String WORKITEM_5_1_6_2FutureDates = "12";
	public static final String WORKITEM_5_1_6_3DateRange = "13";

	
	//Val5_1_6_1NullValues
	//Val5_1_6_1NullValuesActivation
	//Val5_1_6_1NullValuesCombatPay
	//Val5_1_6_1NullValuesDeployment
	//Val5_1_6_2FutureDates
	//Val5_1_6_3DateRange
	
	/**
	 * An instance of incomingMilitaryServiceEpisode
	 */
	private MilitaryServiceEpisode incomingMilitaryServiceEpisode = null;

	/**
	 * An instance of incomingConflictExperience
	 */
	private AbstractCombatEpisode incomingConflictExperience = null;
	
	private CombatService combatService = null;

	private MilitaryService militaryService = null;
	
	private Activation activation = null;	
	
	private Deployment deployment = null;	
	
	private boolean isDataFromVSSC = false;
	
	private LoadVSSCDataResult loadVSSCDataResult = null;
	
	private boolean improvedByMSDS = false;	// CCR 8395	
	
	private boolean isSeedingIndicator = false; //Seeding Changes
	
	private boolean terminateRuleFlow = false; 	
	
    private String msdsDataSource = null;
    
    private String msdsReceiveStatus = null;    
    
    private String msdsVadirStatus = null;
    
    private String msdsBirlsStatus = null;    
    
    private String msdsWorkItem = null;    
    
    private String msdsOefOifIndicator = null;
    
    private boolean transferToHec = false;    
    
	private boolean noMSDSdata = false;
	
	private boolean impreciseDateDetected = false;
	
	private boolean hasQmse = false;	
	private boolean processQMSEflow = false;	
	private CombatEpisode combatEpisode = null;	
	private CombatEpisode matchedCombatEpisode = null;	
	private MilitaryServiceEpisode matchedMSE = null;	
	private CombatService matchedCombatPay = null;
	private Deployment matchedDeployment = null;		
	private Activation matchedActivation = null;	
	private HashSet<MilitaryServiceEpisode> filteredMseSet = new HashSet<MilitaryServiceEpisode>();
	private ImpreciseDate msdsMessageDate = null;
	
    /**
     * A constructor for validating conflict experience
     * @param ce
     * @param incoming
     * @param pristine
     */
    public MilitaryServiceInputData(MilitaryService militaryInfo, 
                                    Person onFile,
                                    Person pristine,
                                    boolean isDataFromGUI ) {

        super( militaryInfo.getPerson(), onFile, pristine);
        this.setMilitaryService( militaryInfo );
        this.setDataFromGUI( isDataFromGUI );
    }
    
	/**
	 * A constructor for validating conflict experience
	 * @param ce
	 * @param incoming
	 * @param pristine
	 */
	public MilitaryServiceInputData(MilitaryService militaryInfo, 
									Person onFile,
									Person pristine,
									boolean isDataFromGUI,
                                    String useCaseName,
                                    VAFacility sendingFacility) {

		super( militaryInfo.getPerson(), onFile, pristine);
		this.setMilitaryService( militaryInfo );
		this.setDataFromGUI( isDataFromGUI );
        this.setUseCaseName(useCaseName);
        this.setSendingFacility(sendingFacility);
	}
	
    /**
     * A constructor for validating conflict experience
     * @param ce
     * @param incoming
     * @param pristine
     */
    public MilitaryServiceInputData( CombatEpisode ce, 
                                                Person onFile,
                                                Person pristine ) {

        super( ce.getMilitaryService().getPerson(), 
                 onFile, 
                 pristine );
        this.setIncomingConflictExperience( ce );
        this.setMilitaryService( ce.getMilitaryService() );
    }
    
	/**
	 * A constructor for validating conflict experience
	 * @param ce
	 * @param incoming
	 * @param pristine
	 */
	public MilitaryServiceInputData( ConflictExperience ce, 
												Person onFile,
												Person pristine ) {

		super( ce.getMilitaryServiceSiteRecord().getMilitaryService().getPerson(), 
				 onFile, 
				 pristine );
		this.setIncomingConflictExperience( ce );
		this.setMilitaryService( ce.getMilitaryServiceSiteRecord().getMilitaryService() );
	}

	/**
	 * A constructor for military service episode
	 * @param mse
	 * @param incoming
	 * @param pristine
	 */
	public MilitaryServiceInputData( MilitaryServiceEpisode mse, 
												Person onFile,
												Person pristine ) {

		super( mse.getMilitaryServiceSiteRecord().getMilitaryService().getPerson(), 
				 onFile, 
				 pristine );
		this.setIncomingMilitaryServiceEpisode(mse);
		this.setMilitaryService( mse.getMilitaryServiceSiteRecord().getMilitaryService() );
	}

	/**
	 * @return Returns the incomingConflictExperience.
	 */
	public AbstractCombatEpisode getIncomingConflictExperience() {
		return incomingConflictExperience;
	}

	/**
	 * @return Returns the incomingMilitaryServiceEpisode.
	 */
	public MilitaryServiceEpisode getIncomingMilitaryServiceEpisode() {
		return incomingMilitaryServiceEpisode;
	}

	/**
	 * @param incomingConflictExperience
	 *           The incomingConflictExperience to set.
	 */
	public void setIncomingConflictExperience(AbstractCombatEpisode incomingConflictExperience) {
		this.incomingConflictExperience = incomingConflictExperience;
	}

	/**
	 * @param incomingMilitaryServiceEpisode
	 *           The incomingMilitaryServiceEpisode to set.
	 */
	public void setIncomingMilitaryServiceEpisode(
			MilitaryServiceEpisode incomingMilitaryServiceEpisode) {
		this.incomingMilitaryServiceEpisode = incomingMilitaryServiceEpisode;
	}

	/**
	 * @return Returns the militaryService.
	 */
	public MilitaryService getMilitaryService() {
		return militaryService;
	}

	/**
	 * @param militaryService The militaryService to set.
	 */
	public void setMilitaryService(MilitaryService militaryService) {
		this.militaryService = militaryService;
	}

	public boolean isDataFromVSSC() {
		return this.isDataFromVSSC;
	}

	public void setDataFromVSSC(boolean isDataFromVSSC) {
		this.isDataFromVSSC = isDataFromVSSC;
	}

	public LoadVSSCDataResult getLoadVSSCDataResult() {
		return this.loadVSSCDataResult;
	}

	public void setLoadVSSCDataResult(LoadVSSCDataResult loadVSSCDataResult) {
		this.loadVSSCDataResult = loadVSSCDataResult;
	}

	public boolean isImprovedByMSDS() {
		return improvedByMSDS;
	}

	public void setImprovedByMSDS(boolean improvedByMSDS) {
		this.improvedByMSDS = improvedByMSDS;
	}

	public CombatService getCombatService() {
		return combatService;
	}

	public void setCombatService(CombatService combatService) {
		this.combatService = combatService;
	}
	
	//Seeding Changes
	/**
     * @return Returns isSeedingIndicator.
     */
    public boolean getIsSeeding() {
        return this.isSeedingIndicator;
    }
    
    /**
     * @param isSeedingIndicator isSeedingIndicator to set.
     */
    public void setIsSeeding(boolean isSeedingIndicator) {
        this.isSeedingIndicator = isSeedingIndicator;
    }

	public Activation getActivation() {
		return activation;
	}

	public void setActivation(Activation activation) {
		this.activation = activation;
	}

	public Deployment getDeployment() {
		return deployment;
	}

	public void setDeployment(Deployment deployment) {
		this.deployment = deployment;
	}

	public String getMsdsDataSource() {
		return msdsDataSource;
	}

	public void setMsdsDataSource(String msdsDataSource) {
		this.msdsDataSource = msdsDataSource;
	}

	/**
	 * @return the terminateRuleFlow
	 */
	public boolean isTerminateRuleFlow() {
		return terminateRuleFlow;
	}

	/**
	 * @param terminateRuleFlow the terminateRuleFlow to set
	 */
	public void setTerminateRuleFlow(boolean terminateRuleFlow) {
		this.terminateRuleFlow = terminateRuleFlow;
	}

	/**
	 * @return the msdsReceiveStatus
	 */
	public String getMsdsReceiveStatus() {
		return msdsReceiveStatus;
	}

	/**
	 * @param msdsReceiveStatus the msdsReceiveStatus to set
	 */
	public void setMsdsReceiveStatus(String msdsReceiveStatus) {
		this.msdsReceiveStatus = msdsReceiveStatus;
	}

	/**
	 * @return the msdsOefOifIndicator
	 */
	public String getMsdsOefOifIndicator() {
		return msdsOefOifIndicator;
	}

	/**
	 * @param msdsOefOifIndicator the msdsOefOifIndicator to set
	 */
	public void setMsdsOefOifIndicator(String msdsOefOifIndicator) {
		this.msdsOefOifIndicator = msdsOefOifIndicator;
	}
	
	public boolean isTransferToHec() {
		return transferToHec;
	}

	public void setTransferToHec(boolean transferToHec) {
		this.transferToHec = transferToHec;
	}

	/**
	 * @return the msdsBirlsStatus
	 */
	public String getMsdsBirlsStatus() {
		return msdsBirlsStatus;
	}

	/**
	 * @param msdsBirlsStatus the msdsBirlsStatus to set
	 */
	public void setMsdsBirlsStatus(String msdsBirlsStatus) {
		this.msdsBirlsStatus = msdsBirlsStatus;
	}

	/**
	 * @return the msdsVadirStatus
	 */
	public String getMsdsVadirStatus() {
		return msdsVadirStatus;
	}

	/**
	 * @param msdsVadirStatus the msdsVadirStatus to set
	 */
	public void setMsdsVadirStatus(String msdsVadirStatus) {
		this.msdsVadirStatus = msdsVadirStatus;
	}

	/**
	 * @return the noMSDSdata
	 */
	public boolean isNoMSDSdata() {
		return noMSDSdata;
	}

	/**
	 * @param noMSDSdata the noMSDSdata to set
	 */
	public void setNoMSDSdata(boolean noMSDSdata) {
		this.noMSDSdata = noMSDSdata;
	}

	/**
	 * @return the msdsWorkItem
	 */
	public String getMsdsWorkItem() {
		return msdsWorkItem;
	}

	/**
	 * @param msdsWorkItem the msdsWorkItem to set
	 */
	public void setMsdsWorkItem(String msdsWorkItem) {
		this.msdsWorkItem = msdsWorkItem;
	}
	
	public void setImpreciseDateDetected(boolean impreciseDateDetected){
		this.impreciseDateDetected  = impreciseDateDetected;
		
	}
	
	public boolean isImpreciseData() {
		return impreciseDateDetected;
	}

	public CombatEpisode getCombatEpisode() {
		return combatEpisode;
	}

	public void setCombatEpisode(CombatEpisode combatEpisode) {
		this.combatEpisode = combatEpisode;
	}

	public CombatEpisode getMatchedCombatEpisode() {
		return matchedCombatEpisode;
	}

	public void setMatchedCombatEpisode(CombatEpisode matchedCombatEpisode) {
		this.matchedCombatEpisode = matchedCombatEpisode;
	}

	/**
	 * @return the matchedActivation
	 */
	public Activation getMatchedActivation() {
		return matchedActivation;
	}

	/**
	 * @param matchedActivation the matchedActivation to set
	 */
	public void setMatchedActivation(Activation matchedActivation) {
		this.matchedActivation = matchedActivation;
	}

	/**
	 * @return the matchedCombatPay
	 */
	public CombatService getMatchedCombatPay() {
		return matchedCombatPay;
	}

	/**
	 * @param matchedCombatPay the matchedCombatPay to set
	 */
	public void setMatchedCombatPay(CombatService matchedCombatPay) {
		this.matchedCombatPay = matchedCombatPay;
	}

	/**
	 * @return the matchedDeployment
	 */
	public Deployment getMatchedDeployment() {
		return matchedDeployment;
	}

	/**
	 * @param matchedDeployment the matchedDeployment to set
	 */
	public void setMatchedDeployment(Deployment matchedDeployment) {
		this.matchedDeployment = matchedDeployment;
	}

	/**
	 * @return the matchedMSE
	 */
	public MilitaryServiceEpisode getMatchedMSE() {
		return matchedMSE;
	}

	/**
	 * @param matchedMSE the matchedMSE to set
	 */
	public void setMatchedMSE(MilitaryServiceEpisode matchedMSE) {
		this.matchedMSE = matchedMSE;
	}

	public HashSet getFilteredMseSet() {
		return filteredMseSet;
	}
	public void addFilteredMseEntry(MilitaryServiceEpisode episode) {
		if (episode == null) return; //avoid null entries
		filteredMseSet.add(episode);
	}
	public void removeAllFilteredMseEntries() {
		filteredMseSet.clear();
	}

	public boolean hasQmse() {
		return hasQmse;
	}

	public void setHasQmse(boolean hasQmse) {
		this.hasQmse = hasQmse;
	}

	public ImpreciseDate getMsdsMessageDate() {
		return msdsMessageDate;
	}

	public void setMsdsMessageDate(ImpreciseDate msdsMessageDate) {
		this.msdsMessageDate = msdsMessageDate;
	}

	public boolean isProcessQMSEflow() {
		return processQMSEflow;
	}

	public void setProcessQMSEflow(boolean processQMSEflow) {
		this.processQMSEflow = processQMSEflow;
	}
}