/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.rule.data;

// Java classes

// Library classes

// Framework classes

// ESR classes
import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.insurance.PrivateInsurance;
import gov.va.med.esr.common.model.insurance.Medicare;
import gov.va.med.esr.common.model.lookup.VAFacility;

/**
 * @author Carlos Ruiz
 * @version 1.0
 */
public class InsuranceInputData extends BaseData {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -6555824409734977721L;
	private InsurancePolicy insurancePolicy = null;

	/**
	 * Use for validating insurance
	 */
	public InsuranceInputData( InsurancePolicy insurancePolicy ) {
		super();
		this.insurancePolicy = insurancePolicy;
	}

	/**
	 * Use for processing insurance
	 */
	public InsuranceInputData( InsurancePolicy incoming, 
										Person result, 
										Person pristine,
										boolean isUpdatedFromGUI,
										VAFacility sendingFacility) {
		super();

		this.insurancePolicy = incoming;
		this.setIncomingData(incoming.getPerson());
		this.setResultData(result);
		this.setPristineData(pristine);
		this.setDataFromGUI(isUpdatedFromGUI);
		this.setSendingFacility(sendingFacility);
	}

	/**
	 * Use for processing insurance
	 */
	public InsuranceInputData( Person result, 
										InsurancePolicy insurancePolicy ) {
		this.setResultData(result);
		this.insurancePolicy = insurancePolicy;
	}

	public InsurancePolicy getIncomingInsurancePolicy() {
		return insurancePolicy;
	}
	public Medicare getIncomingMedicare() {
		return (insurancePolicy instanceof Medicare) ? (Medicare)this.insurancePolicy : null;
	}
	public PrivateInsurance getIncomingPrivateInsurance() {
		return (insurancePolicy instanceof PrivateInsurance) ? (PrivateInsurance)this.insurancePolicy : null;
	}
}