package gov.va.med.esr.common.rule.data;

// Java classes

// Library classes

// Framework classes

// ESR classes
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.ee.VerificationInfo;

/**
 * @author Carlos Ruiz
 * @version 1.0
 */
public class IneligibilityInputData extends PersonInputData {

    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -7437981183299866566L;

	/**
     * Constuctor for rule that processes data from message without need for workload support
     * 
     * @param incoming
     * @param result
     * @param pristine
     */
    public IneligibilityInputData(Person incoming, Person result, Person pristine) {
        super(incoming, result, pristine, false);
    }
    
    /**
     * Constuctor for rule that processes data from message with workload support
     * 
     * @param incoming
     * @param result
     * @param pristine
     */
    public IneligibilityInputData(Person incoming, Person result, Person pristine, boolean isDataFromUI, VerificationInfo verificationInfo) {
        super(incoming, result, pristine, isDataFromUI, verificationInfo);
    }    

    /**
     * Constructor for rules that need to distinguish data from UI or 
     * messaging.
     * 
     * @param incoming
     * @param result
     * @param pristine
     * @param isDataFromUI
     */
    public IneligibilityInputData(Person incoming, Person result,
            Person pristine, boolean isDataFromUI) {
        super(incoming, result, pristine, isDataFromUI);
    }
    
    /**
     * Constuctor for rule that processes data from message with workload support -- new
     * 
     * @param incoming
     * @param result
     * @param pristine
     */
    public IneligibilityInputData(Person incoming, Person result,
			Person pristine, boolean isDataFromUI, VAFacility sendingFacility,
			VerificationInfo verificationInfo) {
		super(incoming, result, pristine, isDataFromUI, sendingFacility,
				verificationInfo);
	} 
    
    /**
     * Constructor for rules that need to distinguish data from UI or 
     * messaging. -- new
     * 
     * @param incoming
     * @param result
     * @param pristine
     * @param isDataFromUI
     */
    public IneligibilityInputData(Person incoming, Person result,
            Person pristine, VAFacility sendingFacility, boolean isDataFromUI) {
        super(incoming, result, pristine, sendingFacility, isDataFromUI);
    }
}
