/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.rule.data;

// Java classes

// Library classes

// Framework classes
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.service.IVMFinancialInfo;

/**
 * 
 * @author Carlos Ruiz
 * @author Ghazenfer Mansoor
 * @version 1.0
 */
public class FinancialInputData extends BaseData {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 8498612584434516594L;

	private Integer incomingIncomeYear = null;

	private VAFacility sourceFacility = null;
	
	private IncomeTest existingFDTTest = null;

	private boolean isDemographicUpdate = false;
	
	private IVMFinancialInfo ivmFinancialInfo = null;

	private boolean isRXConversion = false;

	private boolean isMTConversion = false;

	private boolean isRXReversal = false;

	private boolean isMTReversal = false;	
	
	protected FinancialInputData() {
		super();
	}

	public FinancialInputData(Person incomingPerson, Person resultPerson,
			Person pristine, Integer incomingIncomeYear,
			boolean isDemographicUpdate, boolean isDataFromGUI) {
		super(incomingPerson, resultPerson, pristine);
		setIncomingIncomeYear(incomingIncomeYear);
		setSourceFacility(sourceFacility);
        setSendingFacility(sourceFacility);
		setDataFromGUI(isDataFromGUI);
		setDemographicUpdate(isDemographicUpdate);
	}

	public FinancialInputData(Person incomingPerson, Person resultPerson,
			Person pristine, Integer incomingIncomeYear, VAFacility sourceFacility) {
		this(incomingPerson, resultPerson, pristine, incomingIncomeYear,
				sourceFacility, false);
	}
	// CCR 12153
	public FinancialInputData(Person incomingPerson, Person resultPerson,
			Person pristine, IVMFinancialInfo ivmFinancialInfo) {
		super(incomingPerson, resultPerson, pristine);	
		if (ivmFinancialInfo != null) {
			setIncomingIncomeYear(ivmFinancialInfo.getIncomeYear());			
		}
		setIvmFinancialInfo(ivmFinancialInfo);
		setDataFromGUI(false);
	}
	public FinancialInputData(Person incomingPerson, Person resultPerson,
			Person pristine, Integer incomingIncomeYear,
			VAFacility sourceFacility, boolean isDataFromGUI) {
		super(incomingPerson, resultPerson, pristine);
		setDataFromGUI(isDataFromGUI);
		setIncomingIncomeYear(incomingIncomeYear);
		setSourceFacility(sourceFacility);
        setSendingFacility(sourceFacility);
	}

	public Integer getIncomingIncomeYear() {
		return incomingIncomeYear;
	}

	public void setIncomingIncomeYear(Integer incomingIncomeYear) {
		this.incomingIncomeYear = incomingIncomeYear;
	}

	public VAFacility getSourceFacility() {
		return sourceFacility;
	}

	public void setSourceFacility(VAFacility sourceFacility) {
		this.sourceFacility = sourceFacility;
	}

	public boolean isDemographicUpdate() {
		return isDemographicUpdate;
	}

	public void setDemographicUpdate(boolean isDemographicUpdate) {
		this.isDemographicUpdate = isDemographicUpdate;
	}

	/**
	 * The FDT that may exist on the result person and that has been identified as 
	 * potentially becoming effective immediately.
	 *  
	 */	
	public IncomeTest getExistingFDTTest() {
		return existingFDTTest;
	}
	
	/**
	 * The FDT that may exist on the result person and that has been identified as 
	 * potentially becoming effective immediately.
	 *  
	 * @param existingFDTTest
	 */
	public void setExistingFDTTest(IncomeTest existingFDTTest) {
		this.existingFDTTest = existingFDTTest;
	}

	public IVMFinancialInfo getIvmFinancialInfo() {
		return ivmFinancialInfo;
	}

	public void setIvmFinancialInfo(IVMFinancialInfo ivmFinancialInfo) {
		this.ivmFinancialInfo = ivmFinancialInfo;
	}

	public boolean isMTConversion() {
		return isMTConversion;
	}

	public void setMTConversion(boolean isMTConversion) {
		this.isMTConversion = isMTConversion;
	}

	public boolean isMTReversal() {
		return isMTReversal;
	}

	public void setMTReversal(boolean isMTReversal) {
		this.isMTReversal = isMTReversal;
	}

	public boolean isRXConversion() {
		return isRXConversion;
	}

	public void setRXConversion(boolean isRXConversion) {
		this.isRXConversion = isRXConversion;
	}

	public boolean isRXReversal() {
		return isRXReversal;
	}

	public void setRXReversal(boolean isRXReversal) {
		this.isRXReversal = isRXReversal;
	}
	
}