/*******************************************************************************
 * Copyright  2006 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.rule.data;

import gov.va.med.esr.common.model.ee.FeeBasis;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;

/**
 * @author DNS   KATIKM
 *
 */
public class FeeBasisInputData extends PersonInputData {

    private static final long serialVersionUID = -2251014951505159800L;

    private FeeBasis incomingFeeBasis = null;
    private FeeBasis onFileFeeBasis = null;
    
    public FeeBasisInputData(Person incoming, Person result, Person pristine,
            VAFacility sendingFacility, 
            FeeBasis incomingFeeBasis, FeeBasis onFileFeeBasis,
            boolean isUpdateFromGUI) {
         super(incoming, result, pristine);
         this.setSendingFacility(sendingFacility);
         this.setUpdateFromGUI(isUpdateFromGUI);
         this.setIncomingFeeBasis(incomingFeeBasis);
         this.setOnFileFeeBasis(onFileFeeBasis);
    }

    public FeeBasis getOnFileFeeBasis() {
        return this.onFileFeeBasis;
    }

    public void setOnFileFeeBasis(FeeBasis onFileFeeBasis) {
        this.onFileFeeBasis = onFileFeeBasis;
    }

    public FeeBasis getIncomingFeeBasis() {
        return this.incomingFeeBasis;
    }

    public void setIncomingFeeBasis(FeeBasis incomingFeeBasis) {
        this.incomingFeeBasis = incomingFeeBasis;
    }    
}
