package gov.va.med.esr.common.rule.data;


// Java classes

// Library classes

// Framework classes

// ESR classes
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.external.demographics.DemographicsChangeEvent;

/**
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class ExternalSystemsInputData extends BaseData {

    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 1007642628957259976L;
	private DemographicsChangeEvent demographicsChangeEvent = null;
    
    /**
     * External system will provide only one person.
     * 
     * @param incoming
     * @param demographicsChangeEvent
     */
    public ExternalSystemsInputData(Person incoming, DemographicsChangeEvent demographicsChangeEvent) {
        super(incoming, incoming);
     
        this.setDemographicsChangeEvent(demographicsChangeEvent);
    }

    /**
     * @return Returns the demographicsChangeEvent.
     */
    public DemographicsChangeEvent getDemographicsChangeEvent() {
        return demographicsChangeEvent;
    }

    /**
     * @param demographicsChangeEvent The demographicsChangeEvent to set.
     */
    public void setDemographicsChangeEvent(
            DemographicsChangeEvent demographicsChangeEvent) {
        this.demographicsChangeEvent = demographicsChangeEvent;
    }


}
