package gov.va.med.esr.common.rule.data;

// Java classes

// Library classes

// Framework classes

// ESR classes
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.ee.IncomingMessageInfo;

public class EventInputData extends PersonInputData {
    
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 4132036752601773084L;
	private IncomingMessageInfo incomingMessageInfo = null;
    private Integer incomeYear = null;
   
    /**
     * This constructor is for processing events. The incoming
     * person is also used as result person since person is not being
     * updated, just referenced.
     * 
     * @param incoming
     * @param pristine
     */
    public EventInputData(Person incoming, Person pristine) {
        super(incoming, incoming, pristine);
    }
    
    /**
     * @param incoming
     * @param result
     * @param pristine
     * @param info
     */
    public EventInputData(Person incoming, VAFacility sendingFacility, Person result, Person pristine, VerificationInfo info) {
        super(incoming, result, pristine, false, sendingFacility, info);   //added sendingFacility is isMessageFromVoa can work correctly
    }

    public EventInputData(Person incoming, Person pristine, Integer incomeYear, IncomingMessageInfo incomingMessageInfo, VerificationInfo verificationInfo) {
        super(incoming, incoming, pristine, verificationInfo);

        this.incomeYear = incomeYear;
        this.incomingMessageInfo = incomingMessageInfo;
        this.setSendingFacility(incomingMessageInfo != null ? incomingMessageInfo.getSendingFacility() : null);
        this.setDfn(incomingMessageInfo.getDfn());
    }

    /**
     * @return Returns the incomingMessageInfo.
     */
    public IncomingMessageInfo getIncomingMessageInfo() {
        return incomingMessageInfo;
    }

    /**
     * @param incomingMessageInfo The incomingMessageInfo to set.
     */
    public void setIncomingMessageInfo(IncomingMessageInfo incomingMessageInfo) {
        this.incomingMessageInfo = incomingMessageInfo;
    }

    /**
     * @return Returns the incomeYear.
     */
    public Integer getIncomeYear() {
        return incomeYear;
    }

    /**
     * @param incomeYear The incomeYear to set.
     */
    public void setIncomeYear(Integer incomeYear) {
        this.incomeYear = incomeYear;
    }
    
   
}
