package gov.va.med.esr.common.rule.data;

// Java classes

// Library classes

// Framework classes

// ESR classes
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.VerificationInfo;

/**
 * @author Carlos Ruiz
 * @version 1.0
 */
public class EEInputData extends PersonInputData {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 9160869779697801730L;
	/**
	 * An instance of resultEnrollmentDetermination
	 */
	private EnrollmentDetermination resultEnrollmentDetermination = null;
	
	private String messageControlId;
    
	/**
	 * A default constructor
	 * @param incoming
	 * @param isUpdateFromGUI
	 */
	public EEInputData( Person incoming, boolean isUpdateFromGUI ) {
		super(incoming, isUpdateFromGUI);
	}

	/**
	 * A default constructor
	 * @param incoming
	 * @param onFile
	 * @param isUpdateFromGUI
	 */
	public EEInputData( Person incoming, Person onFile, boolean isUpdateFromGUI ) {
		super(incoming, onFile, isUpdateFromGUI);
	}


    /**
     * 
     * @param incoming
     * @param onFile
     * @param pristine
     * @param resultEnrollment
     * @param isUpdateFromGUI
     * @param isReviewOnly
     */
    public EEInputData( Person incoming, Person onFile, Person pristine, EnrollmentDetermination resultEnrollment, boolean isUpdateFromGUI,
            boolean isReviewOnly, VAFacility sendingFacility) {
		super(incoming, onFile, pristine, sendingFacility, isUpdateFromGUI);
		
        this.setResultEnrollmentDetermination(resultEnrollment);
        this.setReviewOnly(isReviewOnly);
	}

	/**
	 * A default constructor
	 * @param incoming
	 * @param onFile
	 * @param pristine
	 * @param info
	 */
	public EEInputData( Person incoming, Person onFile, Person pristine, VerificationInfo info ) {
		super(incoming, onFile, pristine, false);
		this.setVerificationInfo( info );
	}

	/**
	 * A default constructor
	 * @param incoming
	 * @param onFile
	 * @param pristine
	 * @param isDataFromGUI
	 */
	public EEInputData( Person incoming, Person onFile, Person pristine, boolean isDataFromGUI ) {
		super(incoming, onFile, pristine, isDataFromGUI);
	}
    
    /**
     * A default constructor
     * @param incoming
     * @param onFile
     * @param pristine
     * @param isDataFromGUI
     */
    public EEInputData( Person incoming, Person onFile, Person pristine, VerificationInfo info, boolean isDataFromGUI ) {
        super(incoming, onFile, pristine, isDataFromGUI, info);
    }


	/**
	 * @return Returns the resultEnrollmentDetermination.
	 */
	public EnrollmentDetermination getResultEnrollmentDetermination() {
		return resultEnrollmentDetermination;
	}

	/**
	 * @param resultEnrollmentDetermination
	 *           The resultEnrollmentDetermination to set.
	 */
	public void setResultEnrollmentDetermination(
			EnrollmentDetermination resultEnrollmentDetermination) {
		this.resultEnrollmentDetermination = resultEnrollmentDetermination;
	}

	public String getMessageControlId() {
		return messageControlId;
	}

	public void setMessageControlId(String messageControlId) {
		this.messageControlId = messageControlId;
	}

}