/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.rule.data;

import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.data.accessor.DemographicAccessor;
import gov.va.med.esr.common.rule.data.accessor.MessageTriggerAccessor;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import gov.va.med.fw.hl7.Message;

/**
 * Initial javadoc for class ConsistencyCheckInputData.
 * TODO - Add content here
 * 
 * Created Aug 8, 2006 12:02:14 PM
 * @author DNS   BOHMEG
 */
public class ConsistencyCheckInputData extends PersonInputData implements DemographicAccessor, MessageTriggerAccessor {
	private static final long serialVersionUID = 6371059960271645050L;
    
    private MessageType messageType;
	private Message message;
	private PersonTriggerEvent triggerEvent;

	/* 
	 * since for ConsistencyChecks, there is really only one Person (optional), we will also set the result & pristine Person
	 * to be the same.  That way, ConsistencyChecks can reuse existing rules that operate on either
	 * any of the incoming, result or pristine
	 */
	
	public ConsistencyCheckInputData(Person person, PersonTriggerEvent triggerEvent, Message message, MessageType messageType) {
		if(person != null) {
			this.setIncomingData(person);
			this.setPristineData(person);
			this.setResultData(person);
		}
		this.messageType = messageType;
		this.message = message;
		this.triggerEvent = triggerEvent;
	}
	
	public ConsistencyCheckInputData(Person person, MessageType messageType) {
		super(person, person, person); // this constructor assumes non-null Person
		
		this.messageType = messageType;
	}

	/**
	 * @return Returns the messageType.
	 */
	public MessageType getMessageType() {
		return messageType;
	}

	/**
	 * @param messageType The messageType to set.
	 */
	public void setMessageType(MessageType messageType) {
		this.messageType = messageType;
	}

	/**
	 * @return Returns the message.
	 */
	public Message getMessage() {
		return message;
	}

	/**
	 * @param message The message to set.
	 */
	public void setMessage(Message message) {
		this.message = message;
	}

	/**
	 * @return Returns the triggerEvent.
	 */
	public PersonTriggerEvent getTriggerEvent() {
		return triggerEvent;
	}

	/**
	 * @param triggerEvent The triggerEvent to set.
	 */
	public void setTriggerEvent(PersonTriggerEvent triggerEvent) {
		this.triggerEvent = triggerEvent;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.rule.data.accessor.DemographicAccessor#getAddress(gov.va.med.esr.common.rule.data.accessor.PropertyAccessor.DataType)
	 */
	public Address getAddress(DataType dataType) {
		Person person = getPerson(dataType);
		return person != null ? person.getPermanentAddress() : null;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.rule.data.accessor.MessageTriggerAccessor#getMessage(gov.va.med.esr.common.rule.data.accessor.PropertyAccessor.DataType)
	 */
	public Message getMessage(DataType dataType) {
		// since stores this data, use it
		return getMessage();
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.rule.data.accessor.MessageTriggerAccessor#getTriggerEvent(gov.va.med.esr.common.rule.data.accessor.PropertyAccessor.DataType)
	 */
	public PersonTriggerEvent getTriggerEvent(DataType dataType) {
		// since stores this data, use it
		return getTriggerEvent();
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.rule.data.accessor.MessageTriggerAccessor#getMessageType(gov.va.med.esr.common.rule.data.accessor.PropertyAccessor.DataType)
	 */
	public MessageType getMessageType(DataType dataType) {
		// since stores this data, use it
		return getMessageType();
	}
}
