package gov.va.med.esr.common.rule.data;

// Java classes
import java.util.List;

import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.comms.HandBookMailQueue;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.data.accessor.DemographicAccessor;
import gov.va.med.esr.service.trigger.LetterTriggerEvent;
import gov.va.med.esr.service.IVMFinancialInfo;

/**
 * @author DNS   RUIZC
 * @version 1.0
 */
public class CommsInputData extends BaseData implements DemographicAccessor{

    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -8121128070232988245L;

	private CommsLogEntry commsLogEntry = null;
    
    private List commsLogEntries = null;    

    private CommsLogEntry resultCommsLogEntry = null;    
    
    private Address mailingAddress = null;
    
    private Address updatedMailingAddress = null;
    
    private boolean overrideRequest = false;
    
    private CommsLogEntry pristineCommsLogEntry = null;
    
    private boolean addressChanged = false;
    
    private ComLetterTemplateType formNumber = null;
    
    private String workflowCaseId = null;
    
    private LetterTriggerEvent.MailType mailType = null;    
    
    private String subject = null;
    
    private String ruleContext = null;    
    
    // CCR11304 -- added to support undeliverable handbook
	private HandBookMailQueue handbookMailQueue = null;

    private HandBookMailQueue resultHandbookMailQueue = null;    
    
    private boolean isProcessingHandbook = false;
    
    private IVMFinancialInfo ivmFinancialInfo = null;
    
    /**
     * 
     * 
     * @param incoming
     * @param incomingEntry
     * @param onFileEntry
     * @param mailingAddress
     */
    public CommsInputData(Person incoming, CommsLogEntry incomingEntry, CommsLogEntry onFileEntry, Address mailingAddress, Address updatedMailingAddress ) {
        super(incoming, incoming, incoming);
        
        this.setCommsLogEntry(incomingEntry);
        this.setResultCommsLogEntry(onFileEntry);
        this.setMailingAddress(mailingAddress);
        this.setUpdatedMailingAddress(updatedMailingAddress);
    }
    
    /**
     * CCR11304 -- added to support handling undeliverable handbook
     * @param incoming
     * @param incomingEntry
     * @param onFileEntry
     * @param mailingAddress
     * @param updatedMailingAddress
     */
    public CommsInputData(Person incoming, HandBookMailQueue incomingEntry, HandBookMailQueue onFileEntry, Address mailingAddress, Address updatedMailingAddress ) {
        super(incoming, incoming, incoming);
        
        this.setHandbookMailQueue(incomingEntry);
        this.setResultHandbookMailQueue(onFileEntry);
        this.setMailingAddress(mailingAddress);
        this.setUpdatedMailingAddress(updatedMailingAddress);
        this.setProcessingHandbook(true);
    }

    /**
     * Constructor for validation
     * 
     * @param incoming
     * @param incomingEntry
     * @param mailingAddress
     */
    public CommsInputData(Person incoming, CommsLogEntry incomingEntry, Address mailingAddress) {
        super(incoming, incoming, incoming);
        
        this.setCommsLogEntry(incomingEntry);
        this.setMailingAddress(mailingAddress);
    }    
    
    public CommsInputData(Person incoming, Person pristine) {
        super(incoming, incoming, pristine);
    }  
    
    
    public CommsInputData(Person person, ComLetterTemplateType formNumber, String workflowCaseId, LetterTriggerEvent.MailType mailType, Boolean override) {
        super(person, person, person);
        
        this.setFormNumber(formNumber);
        this.setWorkflowCaseId(workflowCaseId);
        this.setMailType(mailType);
        this.setOverrideRequest(override != null ? override.booleanValue() : false);
    }      
    
    /**
     * @return Returns the commsLogEntry.
     */
    public CommsLogEntry getCommsLogEntry() {
        return commsLogEntry;
    }

    /**
     * @param commsLogEntry The commsLogEntry to set.
     */
    public void setCommsLogEntry(CommsLogEntry commsLogEntry) {
        this.commsLogEntry = commsLogEntry;
    }


    /**
     * @return Returns the mailingAddress.
     */
    public Address getMailingAddress() {
        return mailingAddress;
    }

    /**
     * @param mailingAddress The mailingAddress to set.
     */
    public void setMailingAddress(Address mailingAddress) {
        this.mailingAddress = mailingAddress;
    }

    /**
     * @return Returns the overrideRequest.
     */
    public boolean isOverrideRequest() {
        return overrideRequest;
    }

    /**
     * @param overrideRequest The overrideRequest to set.
     */
    public void setOverrideRequest(boolean overrideRequest) {
        this.overrideRequest = overrideRequest;
    }

    /**
     * @return Returns the pristineCommsLogEntry.
     */
    public CommsLogEntry getPristineCommsLogEntry() {
        return pristineCommsLogEntry;
    }

    /**
     * @param pristineCommsLogEntry The pristineCommsLogEntry to set.
     */
    public void setPristineCommsLogEntry(CommsLogEntry pristineCommsLogEntry) {
        this.pristineCommsLogEntry = pristineCommsLogEntry;
    }

    /**
     * @return Returns the addressChanged.
     */
    public boolean isAddressChanged() {
        return addressChanged;
    }

    /**
     * @param addressChanged The addressChanged to set.
     */
    public void setAddressChanged(boolean addressChanged) {
        this.addressChanged = addressChanged;
    }


    /**
     * @return Returns the workflowCaseId.
     */
    public String getWorkflowCaseId() {
        return workflowCaseId;
    }

    /**
     * @param workflowCaseId The workflowCaseId to set.
     */
    public void setWorkflowCaseId(String workflowCaseId) {
        this.workflowCaseId = workflowCaseId;
    }

    /**
     * @return Returns the resultCommsLogEntry.
     */
    public CommsLogEntry getResultCommsLogEntry() {
        return resultCommsLogEntry;
    }

    /**
     * @param resultCommsLogEntry The resultCommsLogEntry to set.
     */
    public void setResultCommsLogEntry(CommsLogEntry resultCommsLogEntry) {
        this.resultCommsLogEntry = resultCommsLogEntry;
    }

    /**
     * @return Returns the commsLogEntries.
     */
    public List getCommsLogEntries() {
        return commsLogEntries;
    }

    /**
     * @param commsLogEntries The commsLogEntries to set.
     */
    public void setCommsLogEntries(List commsLogEntries) {
        this.commsLogEntries = commsLogEntries;
    }


    /**
     * @return Returns the mailType.
     */
    public LetterTriggerEvent.MailType getMailType() {
        return mailType;
    }

    /**
     * @param mailType The mailType to set.
     */
    public void setMailType(LetterTriggerEvent.MailType mailType) {
        this.mailType = mailType;
    }

    /**
     * @return Returns the updatedMailingAddress.
     */
    public Address getUpdatedMailingAddress() {
        return updatedMailingAddress;
    }

    /**
     * @param updatedMailingAddress The updatedMailingAddress to set.
     */
    public void setUpdatedMailingAddress(Address updatedMailingAddress) {
        this.updatedMailingAddress = updatedMailingAddress;
    }

    /**
     * @return Returns the formNumber.
     */
    public ComLetterTemplateType getFormNumber() {
        return formNumber;
    }

    /**
     * @param formNumber The formNumber to set.
     */
    public void setFormNumber(ComLetterTemplateType formNumber) {
        this.formNumber = formNumber;
    }

    /**
     * @return Returns the subject.
     */
    public String getSubject() {
        return subject;
    }

    /**
     * @param subject The subject to set.
     */
    public void setSubject(String subject) {
        this.subject = subject;
    }

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.rule.data.accessor.DemographicAccessor#getAddress(gov.va.med.esr.common.rule.data.accessor.PropertyAccessor.DataType)
	 */
	public Address getAddress(DataType dataType) {
		// since this stores this data, use it
		return getMailingAddress();
	}

    /**
     * @return Returns the ruleContext.
     */
    public String getRuleContext() {
        return ruleContext;
    }

    /**
     * @param ruleContext The ruleContext to set.
     */
    public void setRuleContext(String ruleContext) {
        this.ruleContext = ruleContext;
    }

	public HandBookMailQueue getHandbookMailQueue() {
		return handbookMailQueue;
	}

	public void setHandbookMailQueue(HandBookMailQueue handbookMailQueue) {
		this.handbookMailQueue = handbookMailQueue;
	}

	public HandBookMailQueue getResultHandbookMailQueue() {
		return resultHandbookMailQueue;
	}

	public void setResultHandbookMailQueue(HandBookMailQueue resultHandbookMailQueue) {
		this.resultHandbookMailQueue = resultHandbookMailQueue;
	}

	public boolean isProcessingHandbook() {
		return isProcessingHandbook;
	}

	public void setProcessingHandbook(boolean isProcessingHandbook) {
		this.isProcessingHandbook = isProcessingHandbook;
	}

	public IVMFinancialInfo getIvmFinancialInfo() {
		return ivmFinancialInfo;
	}

	public void setIvmFinancialInfo(IVMFinancialInfo ivmFinancialInfo) {
		this.ivmFinancialInfo = ivmFinancialInfo;
	}
	
}
