/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule.data;

// Java classes

// Library classes

// Framework classes
import gov.va.med.fw.rule.SimpleRuleDataAware;

// ESR classes
import gov.va.med.esr.common.model.ee.CatastrophicDisability;
import gov.va.med.esr.common.model.ee.ClinicalDetermination;
import gov.va.med.esr.common.model.ee.MilitarySexualTrauma;
import gov.va.med.esr.common.model.ee.NoseThroatRadium;
import gov.va.med.esr.common.model.person.Person;


/**
 * This class provides data when doing validations on subtypes of
 * Clinical Determination.
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class ClinicalDeterminationInputData extends SimpleRuleDataAware {

    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -4667932034773820738L;

	private CatastrophicDisability incomingCatastrophicDisability = null;

    private CatastrophicDisability pristineCatastrophicDisability = null;

    private MilitarySexualTrauma pristineMilitarySexualTrauma = null;

    private MilitarySexualTrauma incomingMilitarySexualTrauma = null;

    private NoseThroatRadium incomingNoseThroatRadium = null;

    private NoseThroatRadium pristineNoseThroatRadium = null;

    private ClinicalDetermination incomingClinicalDetermination = null;

    private ClinicalDetermination pristineClinicalDetermination = null;

    /**
     * Constructor for use when doing E&E calc
     * 
     * @param incoming
     * @param result
     * @param pristine
     */
    public ClinicalDeterminationInputData(Person incoming, Person result,
            Person pristine) {
        super();

        this.setIncomingData(incoming);
        this.setResultData(result);
        this.setPristineData(pristine);
    }

    /** 
     * Constructor for use when processing clinical determinations.
     *  
     * @param incoming
     * @param result
     * @param pristine
     */
    public ClinicalDeterminationInputData(Person incoming, Person result,
            Person pristine, ClinicalDetermination clinicalDetermination) {
        super();

        this.setIncomingData(incoming);
        this.setResultData(result);
        this.setPristineData(pristine);
        this.setIncomingClinicalDetermination(clinicalDetermination);
    }

    /**
     * Use for validation of clinicalDetermination
     * 
     * @param clinicalDetermination
     */
    public ClinicalDeterminationInputData(
            ClinicalDetermination clinicalDetermination) {
        super();

        this.setIncomingClinicalDetermination(clinicalDetermination);
    }

    public ClinicalDeterminationInputData(
            CatastrophicDisability catastrophicDisability) {
        super();

        this.setIncomingCatastrophicDisability(catastrophicDisability);
    }

    /**
     * Constructor for use when validating an MST
     * 
     * @param militarySexualTrauma
     */
    public ClinicalDeterminationInputData(
            MilitarySexualTrauma militarySexualTrauma) {
        super();

        this.setIncomingMilitarySexualTrauma(militarySexualTrauma);
    }

    /**
     * Constructor for use when validating an NTR
     * 
     * @param incomingNoseThroatRadium
     * @param pristineNoseThroatRadium
     */
    public ClinicalDeterminationInputData(
            NoseThroatRadium incomingNoseThroatRadium,
            NoseThroatRadium pristineNoseThroatRadium) {
        super();

        this.setIncomingNoseThroatRadium(incomingNoseThroatRadium);
        this.setPristineNoseThroatRadium(pristineNoseThroatRadium);
    }

    /**
     * @return Returns the incomingCatastrophicDisability.
     */
    public CatastrophicDisability getIncomingCatastrophicDisability() {
        return incomingCatastrophicDisability;
    }

    /**
     * @param incomingCatastrophicDisability
     *            The incomingCatastrophicDisability to set.
     */
    public void setIncomingCatastrophicDisability(
            CatastrophicDisability incomingCatastrophicDisability) {
        this.incomingCatastrophicDisability = incomingCatastrophicDisability;
    }

    /**
     * @return Returns the incomingClinicalDetermination.
     */
    public ClinicalDetermination getIncomingClinicalDetermination() {
        return incomingClinicalDetermination;
    }

    /**
     * @param incomingClinicalDetermination
     *            The incomingClinicalDetermination to set.
     */
    public void setIncomingClinicalDetermination(
            ClinicalDetermination incomingClinicalDetermination) {
        this.incomingClinicalDetermination = incomingClinicalDetermination;
    }

    /**
     * @return Returns the incomingMilitarySexualTrauma.
     */
    public MilitarySexualTrauma getIncomingMilitarySexualTrauma() {
        return incomingMilitarySexualTrauma;
    }

    /**
     * @param incomingMilitarySexualTrauma
     *            The incomingMilitarySexualTrauma to set.
     */
    public void setIncomingMilitarySexualTrauma(
            MilitarySexualTrauma incomingMilitarySexualTrauma) {
        this.incomingMilitarySexualTrauma = incomingMilitarySexualTrauma;
    }

    /**
     * @return Returns the incomingNoseThroatRadium.
     */
    public NoseThroatRadium getIncomingNoseThroatRadium() {
        return incomingNoseThroatRadium;
    }

    /**
     * @param incomingNoseThroatRadium
     *            The incomingNoseThroatRadium to set.
     */
    public void setIncomingNoseThroatRadium(
            NoseThroatRadium incomingNoseThroatRadium) {
        this.incomingNoseThroatRadium = incomingNoseThroatRadium;
    }

    /**
     * @return Returns the pristineCatastrophicDisability.
     */
    public CatastrophicDisability getPristineCatastrophicDisability() {
        return pristineCatastrophicDisability;
    }

    /**
     * @param pristineCatastrophicDisability
     *            The pristineCatastrophicDisability to set.
     */
    public void setPristineCatastrophicDisability(
            CatastrophicDisability pristineCatastrophicDisability) {
        this.pristineCatastrophicDisability = pristineCatastrophicDisability;
    }

    /**
     * @return Returns the pristineClinicalDetermination.
     */
    public ClinicalDetermination getPristineClinicalDetermination() {
        return pristineClinicalDetermination;
    }

    /**
     * @param pristineClinicalDetermination
     *            The pristineClinicalDetermination to set.
     */
    public void setPristineClinicalDetermination(
            ClinicalDetermination pristineClinicalDetermination) {
        this.pristineClinicalDetermination = pristineClinicalDetermination;
    }

    /**
     * @return Returns the pristineMilitarySexualTrauma.
     */
    public MilitarySexualTrauma getPristineMilitarySexualTrauma() {
        return pristineMilitarySexualTrauma;
    }

    /**
     * @param pristineMilitarySexualTrauma
     *            The pristineMilitarySexualTrauma to set.
     */
    public void setPristineMilitarySexualTrauma(
            MilitarySexualTrauma pristineMilitarySexualTrauma) {
        this.pristineMilitarySexualTrauma = pristineMilitarySexualTrauma;
    }

    /**
     * @return Returns the pristineNoseThroatRadium.
     */
    public NoseThroatRadium getPristineNoseThroatRadium() {
        return pristineNoseThroatRadium;
    }

    /**
     * @param pristineNoseThroatRadium
     *            The pristineNoseThroatRadium to set.
     */
    public void setPristineNoseThroatRadium(
            NoseThroatRadium pristineNoseThroatRadium) {
        this.pristineNoseThroatRadium = pristineNoseThroatRadium;
    }
}