/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule.data;

// Java classes

// Library classes

// Framework classes
import gov.va.med.esr.common.batchprocess.SSASSNVerificationData;
import gov.va.med.esr.common.clock.Clock;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.EEResultInfo;
import gov.va.med.fw.rule.SimpleRuleDataAware;

public abstract class BaseData extends SimpleRuleDataAware  {

    private static final long serialVersionUID = -1370346746640850300L;
    private boolean isDataFromGUI = false;

    private boolean isDataFromMVI = false;

    private String useCaseName = null;

    private boolean isReviewOnly = false;

    private boolean isCleanup = false;

    private EEResultInfo eEResultInfo = null;

    private boolean z10Sent = false;

    private EGTSetting activeEGTSetting = null;

    private VAFacility sendingFacility;

    private String dfn;

    private Integer incomeYearForCurrentTest = null;

    // Indicate what clock fired
    private Clock.Type firedClockType = null;

	private boolean isVOAapplication = false;	// For CCR 8395

	private boolean triggerMSDSBroker = false;

	 private boolean fromAddNewPerson = false;

    protected BaseData() {
        super();
    }

    protected BaseData(Person incoming, Person result, Person pristine) {
        super();

        this.setIncomingData(incoming);
        this.setResultData(result);
        this.setPristineData(pristine);
    }

    protected BaseData(Person incoming, Person result) {
        super();

        this.setIncomingData(incoming);
        this.setResultData(result);
        this.setPristineData(null);
    }

    protected BaseData(Person incoming) {
        super();

        this.setIncomingData(incoming);
        this.setResultData(null);
        this.setPristineData(null);
    }

    protected BaseData(EGTSetting incoming, EGTSetting result) {
        super();

        this.setIncomingData(incoming);
        this.setResultData(result);
    }

    protected BaseData(SSASSNVerificationData incoming, SSASSNVerificationData result) {
        super();

        this.setIncomingData(incoming);
        this.setResultData(result);
    }

    /**
     * @return Returns the useCaseName.
     */
    public String getUseCaseName() {
        return useCaseName;
    }

    /**
     * @return Returns the useCaseName.
     */
    public void setUseCaseName(String useCaseName) {
        this.useCaseName = useCaseName;
    }

    /**
     * @return Returns the isDataFromGUI.
     */
    public boolean isDataFromGUI() {
        return isDataFromGUI;
    }

    /**
     * @param isDataFromGUI The isDataFromGUI to set.
     */
    public void setDataFromGUI(boolean isDataFromGUI) {
        this.isDataFromGUI = isDataFromGUI;
    }

    /**
     * @return Returns the isDataFromGUI.
     */
    public boolean isDataFromMVI() {
        return isDataFromMVI;
    }

    /**
     * @param isDataFromGUI The isDataFromGUI to set.
     */
    public void setDataFromMVI(boolean isDataFromMVI) {
        this.isDataFromMVI = isDataFromMVI;
    }

    /**
     * @return Returns the firedClockType.
     */
    public Clock.Type getFiredClockType() {
        return firedClockType;
    }

    /**
     * @param firedClockType The firedClockType to set.
     */
    public void setFiredClockType(Clock.Type firedClockType) {
        this.firedClockType = firedClockType;
    }

    /**
     * @return Returns the isReviewOnly.
     */
    public boolean isReviewOnly() {
        return isReviewOnly;
    }

    /**
     * @param isReviewOnly The isReviewOnly to set.
     */
    public void setReviewOnly(boolean isReviewOnly) {
        this.isReviewOnly = isReviewOnly;
    }

    /**
     * @return Returns the activeEGTSetting.
     */
    public EGTSetting getActiveEGTSetting() {
        return activeEGTSetting;
    }

    /**
     * @param activeEGTSetting The activeEGTSetting to set.
     */
    public void setActiveEGTSetting(EGTSetting activeEGTSetting) {
        this.activeEGTSetting = activeEGTSetting;
    }


    /**
     * @return Returns the sendingFacility.
     */
    public VAFacility getSendingFacility()
    {
        return sendingFacility;
    }
    /**
     * @param sendingFacility The sendingFacility to set.
     */
    public void setSendingFacility(VAFacility sendingFacility)
    {
        this.sendingFacility = sendingFacility;
    }

    /**
     * @return Returns the dfn.
     */
    public String getDfn() {
        return dfn;
    }

    /**
     * @param dfn The dfn to set.
     */
    public void setDfn(String dfn) {
        this.dfn = dfn;
    }

    /**
     * @return Returns the incomeYearForCurrentTest.
     */
    public Integer getIncomeYearForCurrentTest() {
        return incomeYearForCurrentTest;
    }

    /**
     * @param incomeYearForCurrentTest The incomeYearForCurrentTest to set.
     */
    public void setIncomeYearForCurrentTest(Integer incomeYearForCurrentTest) {
        this.incomeYearForCurrentTest = incomeYearForCurrentTest;
    }

    /**
     * @return Returns the z10Sent.
     */
    public boolean isZ10Sent() {
        return z10Sent;
    }

    /**
     * @param sent The z10Sent to set.
     */
    public void setZ10Sent(boolean sent) {
        z10Sent = sent;
    }

    /**
     *
     * @return
     */
	public boolean isCleanup() {
		return isCleanup;
	}

	/**
	 * Returns the EEResultInfo
	 *
	 * @return EEResultInfo
	 */
	public EEResultInfo getEEResultInfo() {
		return eEResultInfo;
	}

	public void setEEResultInfo(EEResultInfo eEResultInfo) {
		this.eEResultInfo = eEResultInfo;
	}

	/**
	 *
	 * @param isCleanup
	 */
	public void setCleanup(boolean isCleanup) {
		this.isCleanup = isCleanup;
	}

    /**
	 * @return the isVOAapplication
	 */
	public boolean isVOAapplication() {
		return isVOAapplication;
	}

	/**
	 * @param isVOAapplication the isVOAapplication to set
	 */
	public void setVOAapplication(boolean isVOAapplication) {
		this.isVOAapplication = isVOAapplication;
	}

	public boolean isTriggerMSDSBroker() {
		return triggerMSDSBroker;
	}

	public void setTriggerMSDSBroker(boolean triggerMSDSBroker) {
		this.triggerMSDSBroker = triggerMSDSBroker;
	}
	 /**
     * @return Returns the fromAddNewPerson.
     */
    public boolean isFromAddNewPerson() {
        return fromAddNewPerson;
    }

    /**
     * @param sent The fromAddNewPerson to set.
     */
    public void setFromAddNewPerson(boolean fromAddNewPerson) {
    	this.fromAddNewPerson = fromAddNewPerson;
    }
}
