/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule.data;


// Java classes

// Library classes

// Framework classes

// ESR classes
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Person;

/**
 * @author Carlos Ruiz
 * @version 1.0
 */
public class AssociationInputData extends BaseData {

    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -1524451535066886528L;
	private Association incomingAssociation = null;
    
    /**
     * A default constructor for association validation
     */
    public AssociationInputData(Association association, boolean isDataFromGUI) {
        super(association.getPerson());
        
        this.setIncomingAssociation(association);
        this.setDataFromGUI(isDataFromGUI);
    }

    /**
     * Constructor for Process Association 
     */
    public AssociationInputData( Association association, 
   		 							   Person result, 
   		 							   Person pristine,
   		 							   boolean isDataFromGUI,
   		 							   VAFacility sendingFacility) {
        super(association.getPerson(), result, pristine);
        
        this.setIncomingAssociation(association);
        this.setDataFromGUI(isDataFromGUI);
        setSendingFacility(sendingFacility);
    }

    /**
     * Constructor for Process Association 
     */
    public AssociationInputData( Association association, 
   		 							   Person result, 
   		 							   Person pristine ) {
   	 this( association, result, pristine, false, null );
    }
    
    public AssociationInputData( Person incoming, Person onFile, Person pristine ) {
      super( incoming, onFile, pristine );
    }

    /**
     * @return Returns the incomingAssociation.
     */
    public Association getIncomingAssociation() {
        return incomingAssociation;
    }

    /**
     * @param incomingAssociation The incomingAssociation to set.
     */
    public void setIncomingAssociation(Association incomingAssociation) {
        this.incomingAssociation = incomingAssociation;
    }
}