/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.rule;

// Java classes

// Library classes

// Framework classes
import gov.va.med.fw.rule.RuleException;

/** Provides methods to create a workoad case according to specifi business rules. </br>
 * These methods are called in business rules executed in the ILOG JRule rule engine. </br>
 * 
 * @author Vu Le
 * @version 1.0
 */
public interface WorkloadInput extends BaseInput {

	/**
     * Create DQ case if zipcode is invalid
	 */
	public void createCaseIfZipCodeisInvalid(String oldZipCode, String newZipCode) throws RuleException;

    /**
     * Create workload case
     * @param groupType
     * @param caseType
     * @param issueType
     * @param description
     * @throws RuleException
     */
    public void createWorkloadCase(String groupType, String caseType, String issueType, String description) throws RuleException;	

    /**
     * Close PH cases if Open
     * @throws RuleException
     */
    public void setWorkloadCaseToClosed() throws RuleException;

    /**
     * Assign PH Cases to LAS
     * @throws RuleException
     */
	public void assignPHCaseToAssignedLas() throws RuleException;
}