/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.rule;

// Java classes

// Library classes

// Framework classes
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.EntityKey;

// ESR classes

/**
 * 
 *
 * Project: Common</br>
 * Created on: 6:13:34 PM </br>
 *
 * @author DNS   LEV
 */
public interface UpdateMessageEventInput extends MessageEventInput {
	

	public void addUpdatedInsuranceEntityKeys( EntityKey key );
    public void addUpdatedInsuranceEntityKeys(AbstractEntity entity);
    
	public void addUpdatedAssociationEntityKeys( EntityKey key );
    public void addUpdatedAssociationEntityKeys( AbstractEntity entity ); 
    public void addUpdatedAssociationEntityKeys( AbstractEntity entity, VAFacility sendingFacility );
	public void addUpdatedAddressEntityKeys( EntityKey key );
	public void addUpdatedAddressEntityKeys( EntityKey key, VAFacility sendingFacility );
	
	public void updateMessageEvents();
	public void triggerMFNZEGMessage();
	public boolean isMFKZEGRecievedForCurrentEGT();
	
	public boolean isSendingZ11();
	public void setSendingZ11(boolean b);
	

	public void sendVOAFinalStatusToMHV() ;
	
	public boolean isZ11Sent();
	
	public void setZ11Sent(boolean z11Sent);
	
	public boolean isFromAddNewPerson();
	
	// Add the keys for Address entered by Add Person
	public void addDeferredAddressEntityKeys();
	
	//CCR11898
	public boolean isTempAddressUpdateRecent();
	public void addDeferredAddressEntityKeysForMessaging();

}
