/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.rule;

// Java classes

// Library classes

// Framework classes
import java.util.Date;
import java.util.Set;

import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;
// ESR Classes
import gov.va.med.esr.common.model.ee.CampLejeuneVerification;
import gov.va.med.esr.common.model.ee.CampLejeuneVerificationMethod;
import gov.va.med.esr.common.model.ee.RadiationExposure;
import gov.va.med.esr.common.model.ee.AgentOrangeExposure;
import gov.va.med.esr.common.model.ee.EnvironmentalContaminationExposure;
import gov.va.med.esr.common.model.lookup.AgentOrangeExposureLocation;
import gov.va.med.esr.common.model.lookup.CampLejeuneChangeSource;
import gov.va.med.esr.common.model.lookup.CampLejeuneVerificationType;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.RadiationExposureMethod;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;

/**
 * @author Carlos Ruiz
 * @version 1.0
 */
public interface SpecialFactorInput extends BaseInput {

	public boolean isPartOfShadFile();
	// 	CR 9803 & CCR 10023
	public boolean isPartOfShadFile(Person person);

	public AgentOrangeExposure getAgentOrangeExposure();
	public void setResultAgentOrangeExposure(AgentOrangeExposure exposure) throws RuleException;

	public EnvironmentalContaminationExposure getEnvironmentalContaminationExposure();
	public void setResultEnvironmentalContaminants(EnvironmentalContaminationExposure exposure) throws RuleException;

	public RadiationExposure getRadiationExposure();
	public void setResultRadiationExposure(RadiationExposure exposure) throws RuleException;

	public AgentOrangeExposureLocation getAgentOrangeLocation();
	public void setResultAgentOrangeLocation(AgentOrangeExposureLocation location);

	public RadiationExposureMethod getRadiationExposureMethod();
	public void setResultRadiationExposureMethod(RadiationExposureMethod method);

	public AgentOrangeExposure getPristineAgentOrange();
	public AgentOrangeExposureLocation getPristineAgentOrangeLocation();
	public RadiationExposure getPristineRadiationExposure();
	public RadiationExposureMethod getPristineRadiationExposureMethod();

	public AgentOrangeExposure getResultAgentOrange();
	public AgentOrangeExposureLocation getResultAgentOrangeLocation();
	public RadiationExposure getResultRadiationExposure();
	public RadiationExposureMethod getResultRadiationExposureMethod();

    // New methods to support Indicator
    public Boolean getAgentOrangeExposureIndicator();
    public Boolean getEnvironmentalContaminationExposureIndicator();
    public Boolean getRadiationExposureIndicator();
    public Boolean getPristineAgentOrangeIndicator();
    public Boolean getPristineRadiationExposureIndicator();
    public Boolean getPristineEnvironmentalContaminationExposureIndicator();
    public Boolean getResultAgentOrangeIndicator();
    public Boolean getResultRadiationExposureIndicator();

    //CLV//
    public CampLejeuneVerification getCampLejeuneVerification();          //flow agentorange//
    public CampLejeuneVerification getPristineCampLejeuneVerification();
    public CampLejeuneVerification getResultCampLejeuneVerification();  //onfile
    public void    setResultCampLejeuneVerification(CampLejeuneVerification clv)  throws RuleException;
    public void    setResultCampLejeuneVerificationForMS(CampLejeuneVerification clv) throws RuleException;
    public void   setResultCampLejeuneVerificationForCLEAR(CampLejeuneVerification clv) throws RuleException;

    public Boolean getCampLejeuneIndicator();
    public Boolean getPristineCampLejeuneIndicator();
    public Boolean getResultCampLejeuneIndicator();  //onfile
    public void  setResultCampLejeuneIndicator(Boolean id) throws RuleException;

    public CampLejeuneVerificationType getCampLejeuneVerificationType() throws UnknownLookupTypeException, UnknownLookupCodeException;
    public CampLejeuneVerificationType getPristineCampLejeuneVerificationType();
    public CampLejeuneVerificationType getResultCampLejeuneVerificationType();  //onfile
    public void  setResultCampLejeuneVerificationType(CampLejeuneVerificationType clvtype);

    public CampLejeuneChangeSource getCampLejeuneChangeSource();
    public CampLejeuneChangeSource getPristineCampLejeuneChangeSource();
    public CampLejeuneChangeSource getResultCampLejeuneChangeSource();  //onfile
    public void  setResultCampLejeuneChangeSource(CampLejeuneChangeSource clvsource);

    public VAFacility getCampLejeuneChangeSite();
    public VAFacility getPristineCampLejeuneChangeSite();
    public VAFacility getResultCampLejeuneChangeSite();  //onfile
    public void  setResultCampLejeuneChangeSite(VAFacility clvsite);

    public Date getCampLejeuneChangeDate();
    public Date getPristineCampLejeuneChangeDate();
    public Date getResultCampLejeuneChangeDate();  //onfile
    public void  setResultCampLejeuneChangeDate(Date clvdate);

    public String getCampLejeuneComments();
    public String getPristineCampLejeuneComments();
    public String getResultCampLejeuneComments();  //onfile
    public void  setResultCampLejeuneChangeDate(String comments);





    //CLV//

    // System Parameters
    // Agent Orange Special Treatment Authority Indicator
    public Boolean getAOTreatmentAuthorityIndicator() throws ServiceException;
    // Agent Orange Special Treatment Authority Expiration Date
    public Date getAOTreatmentAuthorityExpirationDate() throws ServiceException;
    // SW Asia Conditions Special Treatment Authority Indicator
    public Boolean getECTreamentAuthorityIndicator() throws ServiceException;
   // SW Asia Conditions Special Treatment Authority Expiration Date
    public Date getECTreatmentAuthorityExpirationDate() throws ServiceException;
    public boolean isRadiationExposureMethodChnged();
    public boolean isAgentOrangeLocationChnged();
    public boolean isCurrentCLBlank();
    public boolean isInComingCLYesBlank();
    public void updateCLVByCurrent() throws RuleException;
    public void UpdateResultChangeSiteToHEC()  throws UnknownLookupTypeException, UnknownLookupCodeException;
    public void UpdateResultChangeSourceToVOA() throws UnknownLookupTypeException, UnknownLookupCodeException;
    public  boolean IsEligibilityNonVeteran();
    public boolean IsCurrentCEligibilityVerified();
    public void setVistaCLV() throws RuleException,UnknownLookupTypeException, UnknownLookupCodeException;
    public void setChangeSiteSourceHEC() throws RuleException,UnknownLookupTypeException, UnknownLookupCodeException;
    public boolean isFromVOA();
    public boolean isFromVista();
    public boolean isFromClear();
    public boolean isIgnorePOn() throws RuleException;
    public boolean isCampLejeuneVerificationMethodBlank();

    public Set getCampLejeuneVerificationMethods();
    public Set getPristineCampLejeuneVerificationMethods();
    public Set getResultCampLejeuneVerificationMethods();
    public void  setResultCampLejeuneVerificationMethods(Set<CampLejeuneVerificationMethod> clvmethods);

    //CLV
    public void setNotSupportErrorReason();
    public void setUpdatedIneligibleErrorReason();
    public void  setResultCLRegDateToIncomingCLRegDate();
	public void setErrorReasonNotSupport();
	public void setErrorReasonUpdatedIneligible();
	public boolean isPersonJustAdded();
	public void setErrorReasonVOACLENotDetermined();





}