/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.rule;

// Java classes
import java.util.Date;
import java.util.Set;

// Framework classes
import gov.va.med.fw.rule.RuleException;

// ESR Classes
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.person.Person;

/**
 * This interface gets mapped to a virtual class in ILOG.
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public interface ServiceConnectionInput extends BaseInput {

   public ServiceConnectionAward getServiceConnectionAward() throws RuleException;
   public ServiceConnectionAward getServiceConnectionAward( Person person ) throws RuleException;
   public void addServiceConnectionAward();
   public void removeServiceConnectionAward();

	public Integer getServiceConnectedPercentage() throws RuleException;
   public Integer getServiceConnectedPercentage( Person person ) throws RuleException;
   public void setServiceConnectedPercentage(Integer parm);
   public Integer getCombinedSCPercentageWithNoRDs();
   public boolean isServiceConnectedPercentageChanged() throws RuleException ;
	    
   public Boolean getServiceConnectedIndicator() throws RuleException;
   public Boolean getServiceConnectedIndicator( Person person ) throws RuleException;    

   public Date getCombinedSCPercentageEffectiveDate() throws RuleException;
   public Date getCombinedSCPercentageEffectiveDate( Person person )throws RuleException;
   public void setCombinedSCPercentageEffectiveDate( Date date ) throws RuleException;

   public Set getRatedDisabilities() throws RuleException;
   public Set getRatedDisabilities( Person person ) throws RuleException;
   public void setRatedDisabilities( Set disabilities ) throws RuleException;
   public boolean hasRatedDisabilityMissingPercentageOrCode() throws RuleException;

   public boolean hasRatedDisabilityCodeBeenAdded() throws RuleException ;
   public boolean hasRatedDisabilityCodeBeenRemoved() throws RuleException ;
   public boolean areAACRatedDisabilitiesLessThan() throws RuleException;


   public Boolean getRatedIncompetentIndicator() throws RuleException;
   public Boolean getRatedIncompetentIndicator(Person person) throws RuleException;
   public void setRateIncompetentIndicator(Boolean parameter);
   
   public boolean hasAtleastOneInvalidDisabilityCode();
   
	public Boolean isUnemployable() throws RuleException;
   public Boolean getUnemploymentIndicator( Person person ) throws RuleException;
	public void setUnemploymentIndicator(Boolean parameter);

   public Boolean getPermanentAndTotalIndicator();
   public Boolean getPermanentAndTotalIndicator(Person person);
	public void setPermanentAndTotal(Boolean parameter);
   
	public void setPermanentAndTotalEffectiveDate (Date effectiveDate);
   public Date getPermanentAndTotalEffectiveDate();
   public Date getPermanentAndTotalEffectiveDate( Person person );
   public boolean doesRatedDisabilitiesHaveReceivedCode(String code) throws RuleException;
}