/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule;

// Java classes
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.esr.common.model.registry.RegistryTrait;
import gov.va.med.fw.rule.RuleException;

import java.util.Date;

/**
 * Interface for RegistryInputParameter.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public interface RegistryInput extends BaseInput {
    
    public boolean isNewRegistry();
    public boolean isRegistryExists() throws RuleException;
    public boolean isEnrolled(Person person);
    public boolean isVeteran(Person person);
    public String getReceivedPrimaryEligibilityCode(Person person);
    
    //Common filed getters
    public String getSSN();
    public String getFirstName();
    public String getLastName();
    
    public String getRegistryType();
    public Registry getRegistry();
    
    
    //PH field getters
    public PurpleHeart getPurpleHeart();
    public boolean getPHIndicator();
    public boolean getPristinePHIndicator();
    public void setPHIndicator(boolean indicator);
    public String getPHStatus();
    public String getPristinePHStatus();
    public String getPHRejectedRemarks();
    public void setPHStatusUpdateDate(Date date);
    public void setPHStatusUpdateUser(String user);
    
    //PH/POW/SHAD Document field getters
    public String getPHDocumentType();
    public String getPHDataSource();
    public Date getPHDocumentReceivedDate();
    public Boolean getPHDocumentAcceptable();
    public String getPHAssignedLAS();
    
    public void addPHRegistry();
    public void updatePHRegistry();
    public void linkNewPersonPHRegistry() throws RuleException;
    public void linkExistingPersonPHRegistry() throws RuleException;
    public void linkPersonPHRegistry() throws RuleException;
    
    
    
    //POW field getter
    public PrisonerOfWar getPrisonerOfWar();
    public boolean getPOWIndicator();
    public boolean getPristinePOWIndicator();
    public void setPOWIndicator(boolean indicator);
    public void setPOWDateEntered(Date date);
    public void setPOWEnteredBy(String user);
    public Date getDOD();

    //POW Episode field getters
    public String getPOWDocumentType();
    public String getPOWDataSource();
    public Date getPOWCaptureDate();
    public Date getPOWReleaseDate();
    public String getPOWConfinementLocation();
    
    public void addPOWRegistry();
    public void updatePOWRegistry();
    public void linkNewPersonPOWRegistry() throws RuleException;
    public void linkExistingPersonPOWRegistry() throws RuleException;
    public void linkPersonPOWRegistry() throws RuleException;
    
    
    
    //SHAD field getter
    public SHAD getSHAD();
    public boolean getSHADIndicator();
    public boolean getPristineSHADIndicator();
    public void setSHADIndicator(boolean indicator);
    
    //SHAD Document field getters
    public String getSHADDocumentType();
    public Date getSHADDocumentReceivedDate();
    
    public void addSHADRegistry();
    public void updateSHADRegistry();  
    public void linkNewPersonSHADRegistry() throws RuleException;
    public void linkExistingPersonSHADRegistry() throws RuleException;
    public void linkPersonSHADRegistry() throws RuleException;
    
    //Get the registry trait object
    public RegistryTrait getRegistryTrait(Registry registry);
    
    
    public Person getIncomingPerson();
    
    public Person getResultPerson();
    
    //Load registry APIs
    
    /**
     * Incoming Registry object is matched against existing registry records using the following criteria.  
     * The process should attempt a match in the order specified below, until a criterion is 
     * successfully matched or until no match is found.
     * 		Match on ICN (or person identifier from the Person Table)
	 * 		Match on SSN, Last Name, and First Name
	 * 		Match on SSN, Last Name
	 * 		Match on SSN, First Name 
     * 
     * @return boolean
     */
    public boolean isPersonIdMatched();
    
    public boolean isExactMatch();
    
    /**
     * When match an incoming Registry against an existing person in the registry, 
     * an input record will be considered to be ambiguously matched if the SSN on the input file 
     * matches that on the registry, but none of the other person-identifying information 
     * (Last Name, First Name, month/year of birth) matches.
     * 
     * @return
     */
    public boolean isAmbiguousMatch ();
    
    /**
     * Matches if the incoming Registry is identical to the episode that is already on the registry
     * @return
     */
    public boolean isSameEpisode();
    
    /**
     * Set existing person id to the incoming Registry record.  
     *
     */
    public void setPersonId();
    
    public void writeRegistryException(String message);
    
    public void updateRegistry();
    
    public void addRegistry();
}
