/*******************************************************************************
 * Copyright  2005 VHA. All rights reserved
 ******************************************************************************/

package gov.va.med.esr.common.rule;

// Framework classes
import java.util.Date;

import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;

// ESR Classes
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;

/**
 * @author Muddaiah Ranga
 * @version 1.0
 */
public interface PurpleHeartInput extends BaseInput {

	public String getPurpleHeartIndicator() throws RuleException;

	public String getPurpleHeartStatus() throws Exception;

	public String getVeteranPurpleHeartIndicator();

	public void updatePHPendingClock()  throws RuleException;

	/**
	 * Sets a purple heart indicator
	 * @param indicator A purple indicator "Y", "N"
	 */
	public void setPurpleHeart(String ph);
	
	public void setPurpleHeartIndicator( Boolean indicator );

	public void setPurpleHeartStatus(String status) throws RuleException;

	public VAFacility getReceivedFacility();

	public void setReceivedFacility(VAFacility facility);

	public void setRejectedRemarks(String remark) throws RuleException;

	public boolean isUpdateFromHEC();

	public void updatePurpleHeart() throws RuleException;

	public PurpleHeart getVeteranPurpleHeart();

	public PurpleHeart getPurpleHeart();
	
	public Boolean getPHDocumentAcceptable();
	public Boolean getPriorPHDocumentAcceptable() throws RuleException;
	public String getPriorPurpleHeartStatus() throws RuleException;
	public void start37DayLetterClock() throws RuleException;
	public boolean is37DayClockExpired();
	public String getPHRejectedRemarks();
    public String getVeteranPHRejectedRemarks();    
	
	public boolean hasPHPendingClockExpired();
	public Date getVeteranReceivedDate();
	public void setStatusUpdateDate(Date statusUpdateDate);
	public boolean isFirstDocumentReceived();
	public void acceptPHFromUI() throws RuleException;
	public void cancelPHPendingClock() throws RuleException;
	public void setLoginDate(Date loginDate);
	public void cancelPHLetterClock() throws RuleException;
	public Date getReceivedDate();
	public String getDocumentType();
	public Boolean getDocumentAcceptable();
	public void updatePurpleHeartRegistry() throws ServiceException;
    public String getPurpleHeartStatus( Person person );
    public Boolean isPHDocumentAcceptable(Person person);
    public boolean isAdditionalDocumentReceived();
    /**
     * 
     * @param person
     * @return may return null if not set. else "Y" if yes, "N" if no
     */
    public String getPurpleHeartIndicator( Person person );
    public Boolean getFirstAssessedDocumentAcceptable();
    public Boolean getSecondAssessedDocumentAcceptable();
    public Date getVeteranDateOfBirth();

    // Start CCR 9385
	public void setPHDocumentAcceptableIndicator( String indicator );
	public void setDocumentType(String documentType) throws RuleException;
	
	public void setPHDocumentDataSource(String dataSource) throws RuleException;
	
	public void setPHFacilityByCode(String facilityCode) throws RuleException;
	
	public void setPHLastUpdatedByUser(String user) throws RuleException;
	
	public void setAssignedContactUser(String user) throws RuleException;	
	
	public void setPHDocumentReceivedDate(Date receivedDate);	
	
	public Date getPHDocReceivedDateFromMSDSmessage();

	public void acceptPHFromMSDS() throws RuleException;    
    // End CCR 9385
}