/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Sep 15, 2005
 *
 */
package gov.va.med.esr.common.rule;

import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.rule.RuleException;

// EDB Classes
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.registry.Registry;

/**
 * @author Yi He
 * @version 1.0
 */
public interface PrisonerOfWarInput extends BaseInput {
    /**
     * Comparing the incoming POW record with the onFile POW records. The record is
     * discrepant if the incoming POW has no onFile POW record with the same 
     * start date, end date and confilement location.
     * @return
     */
    boolean isPrisonerOfWarRecordDiscrepant();
    
    /**
     * Return boolean value of incoming person's
     * POW indicator.
     * 
     * @return
     */
    Boolean getPrisonerOfWarIndicator();

    Boolean getPrisonerOfWarIndicator(Person person);
    /**
     * Return boolean value of on file person's
     * POW indicator.
     * 
     * @return
     */
    Boolean getVeteranPrisonerOfWarIndicator();
    
    /**
     * Return String value of incoming person's
     * POW indicator.
     * 
     * @return
     */
    String getPOWIndicatorCode();

    /**
     * Return String value of on file person's
     * POW indicator.
     * 
     * @return
     */
    String getVeteranPOWIndicatorCode();    
    
    public void updatePrisonerOfWar() throws RuleException;
    
    public String getConfinementLocation();
        
    public ImpreciseDate getReleaseDate();
    
    public ImpreciseDate getCaptureDate();
        
    public void removePOWRecord();
    
    public void setCapitivityDays(Integer days);
    
    public Integer calculateCaptivityDays();    
    
    public EntityKey getPOWEntityKey();
    
    public EntityKey getPristinePOWEntityKey();
    
    public Boolean getPriorPrisonerOfWarIndicator() throws RuleException;
    
    /**
     * Get the POW registry record.
     * 
     * @param person
     * @return the POW registry if found otherwise null.
     * @throws RuleException
     */
    public Registry getPOWRegistry(Person person) throws RuleException;
    
    /**
     * Validate that POW episode dates (capture and release) within a MSE
     * @return
     * @throws RuleException
     */
    public Boolean isCaptureAndReleaseDateswithinMSE() throws RuleException;   
    
    /**
     * Validate that Z07 is a VOA
     * @return true or false
     */
     public boolean  isVOA();
     
     public boolean isPrisonerOfWarIndicatorChanged()throws RuleException;
}

