/*****************************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ****************************************************************************************/
package gov.va.med.esr.common.rule;

// Java classes
import java.util.ArrayList;
import java.util.Date;

import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.rule.RuleException;

/**
 * This interface gets mapped to a virtual class in ILOG.
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public interface PersonInput extends BaseInput {

   public void setVeteranIndicator(Boolean setting);

   public boolean isExistingPerson();

   public boolean isUpdateFromGUI();
   public boolean isFromAddNewPerson(); // CCR 10892 Add a Person
   public Integer getUserEnrolleeValidThrough();

   public boolean isVeteran();
   public boolean isVeteran( Person person );

   public String getClaimFolderLocation();

   public String getClaimFolderLocation(Person person);

   public void setClaimFolderLocation(String folder);

   public String getClaimFolderNumber();

   public String getClaimFolderNumber(Person person);

   public void setClaimFolderNumber(String number);

   public Boolean getSensitiveRecordIndicator();

   public Boolean getSensitiveRecordIndicator(Person person);

   public void setSensitiveRecordIndicator(Boolean b);
   public void setSensitiveChangeSource( String source ) throws RuleException ;
   public void setSensitiveChangeDate( Date date );
   public void setSensitiveChangeSite( VAFacility site );
   public Date getSensitiveChangeDate();
   public VAFacility getSensitiveChangeSite();
   

   public String getSignatureIndicator();
   public IncomeTest getPrimaryIncomeTestForSignatureImageIncomeYear();

   public String getPristineSignatureIndicator();

   public ArrayList getPristineSignatureList();

   public boolean hasPrimaryIncomeTest();

   public boolean hasSignatureIndicatorOfNo();

   public void updateSignatureInformation() throws RuleException;

   public Integer getPriorUserEnrolleeValidThrough();

   public boolean hasSignatureIndicatorOfYes();
   
   public int getPristineSignatureIndicatorCountOfYes();
   
   public void setAppointmentRequestDate(Date requestDate);
   public void setAppointmentRequestResponse(Boolean response); 
   
   public boolean isVOAOnly();
   
   public void updateVOAIndicator();
   
   // CR5987 CCR10353 Dental Indicator
   public Boolean getDentalIndicator();
   public void setDentalIndicator(Boolean dentalIndicator);
   public void deleteDentalApplicationDueBeforeDate();
   public void calculateDentalApplicationDueBeforeDate();
   
   public boolean isHandBookTrigger();
   
   /*
    * set the incoming VOA form with status Form Processing Pending flag = true
    */
   public void setVoaFormProcessPendingTrue();
    
}