/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.rule;

// Java classes
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

// Framework classes
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.DateUtils;

// ESR Classes
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.IncompetenceRuling;
import gov.va.med.esr.common.model.ee.Pension;

/**
 * Project: Common</br>
 * Created on: 9:54:00 AM </br>
 *
 * @author DNS   LEV
 */
public interface MonetaryAwardInput extends BaseInput {
	
   public MonetaryBenefit getAidAttendance( Person person ) throws RuleException;
   public MonetaryBenefit getAidAttendance() throws RuleException;

   public Boolean getAidAttendanceIndicator() throws RuleException;
   public Boolean getAidAttendanceIndicator( Person person ) throws RuleException;
   public void setAidAttendanceIndicator( Boolean flag ) throws RuleException;
   
   public MonetaryBenefit getHouseBound() throws RuleException;
   public MonetaryBenefit getHouseBound( Person person ) throws RuleException;
   
   public Boolean getHouseBoundIndicator() throws RuleException;
   public Boolean getHouseBoundIndicator( Person person ) throws RuleException;
   public void setHouseBoundIndicator( Boolean flag ) throws RuleException;
   
   public MonetaryBenefit getVAPension() throws RuleException;
   public MonetaryBenefit getVAPension( Person person ) throws RuleException;
   
   public Boolean getVAPensionIndicator() throws RuleException;
   public Boolean getVAPensionIndicator( Person person ) throws RuleException;
   public void setVAPensionIndicator( Boolean flag ) throws RuleException;
   
   public BigDecimal getTotalCheckAmount() throws RuleException;
   public BigDecimal getTotalCheckAmount( Person person ) throws RuleException;
   public void setTotalCheckAmount(BigDecimal parm);

   public boolean containsMonetaryBenefits() throws RuleException;
   
   public MonetaryBenefit getVADisability() throws RuleException;
   public MonetaryBenefit getVADisability( Person person ) throws RuleException;
   
   public Boolean getVADisabilityIndicator()  throws RuleException;;
   public Boolean getVADisabilityIndicator( Person person )  throws RuleException;;
   public void setVADisabilityIndicator( Boolean flag ) throws RuleException;
   
   public IncompetenceRuling getRatedIncompetentOfVerifiedSite() throws RuleException;
   public IncompetenceRuling getVeteranRatedIncompetent();
   
   public void addMonetaryBenefit( MonetaryBenefit benefit ) throws RuleException;

   // new methods for pension data sharing CR4510 CCR10352
   public Pension getPension() throws RuleException;
   public Date getPristinePensionAwardEffectiveDate() throws RuleException;
   public Date getPensionAwardEffectiveDate() throws RuleException;
   public Date getPensionAwardTerminationDate() throws RuleException;
   public String getPensionAwardReasonCode() throws RuleException;
   public String getPensionAwardTerminationReasonCode1() throws RuleException;
   public String getPensionAwardTerminationReasonCode2() throws RuleException;
   public String getPensionAwardTerminationReasonCode3() throws RuleException;
   public String getPensionAwardTerminationReasonCode4() throws RuleException;
   public Pension getResultPension() throws RuleException;
   public void setPensionAwardEffectiveDate(Date effDate) throws RuleException; 
   public void setPensionAwardTerminationDate(Date termDate) throws RuleException;
   public void setPensionAwardReasonCode(String awaCode) throws RuleException;
   public void setPensionAwardTerminationReasonCode1(String termCode) throws RuleException;
   public void setPensionAwardTerminationReasonCode2(String termCode) throws RuleException;
   public void setPensionAwardTerminationReasonCode3(String termCode) throws RuleException;
   public void setPensionAwardTerminationReasonCode4(String termCode) throws RuleException;
   public boolean isIncomingPensionAwardEffectiveDateGreaterThanToday() throws RuleException;
   public boolean isIncomingPensionAwardTerminationDateGreaterThanToday()throws RuleException;
   public boolean isPensionAwardReasonCodeEqualToZero() throws RuleException;
   public void setPensionAwardTerminationReasonCodes() throws RuleException;
   public void setPensionAwardTerminationReasonCodesToNull() throws RuleException;
   public boolean getPensionStatus(Person person) throws RuleException;
   public boolean isPensionStatusChanged()throws RuleException;
   
   public boolean isPensionAwardReasonCodesDiff() throws RuleException;
   public boolean isPensionAwardEffDateDiff() throws RuleException;
   public Boolean isPensionAwardReasonCodeNull(Person person) throws RuleException;
   public Boolean isPensionAwardEffDateNull(Person person) throws RuleException;
   public boolean getServiceIndicator() throws ServiceException;
   public void pensionIndicatorReset() throws RuleException, ServiceException;
   
}