/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule;

// Java classes
import java.util.Date;
import java.util.Set;

//Library classes

//Framework classes
import gov.va.med.fw.service.ServiceException;

//ESR classes
import gov.va.med.esr.common.batchprocess.LoadVSSCDataResult;
import gov.va.med.esr.common.model.ee.Activation;
import gov.va.med.esr.common.model.ee.CombatService;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.ee.Deployment;
import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.lookup.CombatPayType;
import gov.va.med.esr.common.model.lookup.CombatServiceSource;
import gov.va.med.esr.common.model.lookup.ConflictLocation;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.lookup.MsdsCountry;
import gov.va.med.esr.common.model.lookup.ServiceBranch;
import gov.va.med.esr.common.model.lookup.DischargeType;
import gov.va.med.esr.common.model.lookup.FilipinoVeteranProof;
import gov.va.med.esr.common.model.lookup.MHDataSource;
import gov.va.med.esr.common.model.lookup.TerminationReason;
import gov.va.med.esr.common.model.lookup.SpecialOperation;
import gov.va.med.esr.common.model.lookup.NamedContingency;
import gov.va.med.esr.common.model.person.Person;

/**
 *
 * @author Carlos Ruiz
 * @version 1.0
 */
public interface MilitaryServiceInput extends BaseInput {

    /**
     * This is to get the Combat Veteran Eligibility End Date used for
     * Priority Group 6 and setting other eligibility of Combat Vet.
     */
    public Date getCombatVeteranEligibilityEndDate();

    /**
     * Return boolean value of incoming person's
     * POW indicator.
     *
     * @return
     */
    public boolean getPrisonerOfWarIndicator();

    /**
     * Return boolean value of existing person's
     * POW indicator.
     *
     * @return
     */
    public boolean getVeteranPrisonerOfWarIndicator();

    public String getCurrentPeriodOfService();
    public String getPeriodOfService();

    public boolean hasPeriodOfService(String period);

    public boolean hasAtLeastOnePeriodOfService();

    public Date getCEStartDate();

    public Date getCEEndDate();
    /**
     * @param person encapsulates veteran
     * @return date. may return null if not set
     */
    public Date getCombatVeteranEligibilityEndDate(Person person);
    public ConflictLocation getCombatLocation();
    public String getCombatLocationCode();

    public String getOEFOIFSource();

    public ServiceBranch getServiceBranch();

    public String getServiceComponent();

    public Date getServiceEntryDate();

    public Date getServiceSeparationDate();

    public boolean isSSDPrecise();

    public boolean isSEDPrecise();

    public boolean isCEEndDatePrecise();

    public boolean isCEStartDatePrecise();

    public boolean isOverlappingMSE();

    public DischargeType getServiceDischargeType();

    public Date getServiceOfficialStartDate(String code) throws ServiceException;

    public Date getServiceOfficialEndDate(String code) throws ServiceException;

    public FilipinoVeteranProof getFilipinoVeteranProof();

    public boolean hasMilitaryServiceEpisodes();

    public Date getConflictOfficialEndDate(ConflictLocation conflictLocation);

    public boolean isConflictDateInRange( Date startDate, Date endDate );

    public boolean isOverlappingCombatEpisode();

    public boolean isOverlappingConflictExperience();

    public Date getConflictOfficialStartDate(ConflictLocation conflictLocation);

    public Boolean getDischargeDueToDisability();
    public Boolean getDischargeDueToDisability( Person person );

    public void setDischargeDueToDisability( Boolean flag );

    public Boolean getMilitaryDisabilityRetirement();
    public Boolean getMilitaryDisabilityRetirement( Person person );
    public void setMilitaryDisabilityRetirement( Boolean flag );

    public void updateCombatEpisodes();

    public boolean isOEFOIFCombatDataInconsitant();

    public void setMilitaryServiceInfoBySiteToReceived();

    public Date getMostRecentReceivedSSD();
    public Date getMostRecentReceivedCombatEpisodeEndDate();

    public Date getMostRecentSSDPlus2Years();
    public Date getMostRecentCombatEpisodeEndDatePlus2Years();

    public Date getCurrentCVEligEndDate();

	public Date getOnFileCVEligibilityEndDate();

    public boolean isMostRecentConflictToDateAfterForLocation(Date date, String conflictLocation);

    public String getMostRecentCombatLocation();

    public void setCVEligibilityEndDate(Date combatVeteranEligibilityDate);

    public SHAD getShad();
    public String getShadIndicator() throws ServiceException;
    public String getPristineShadIndicator() throws ServiceException;
    public void setShadIndicator(String indicator) throws ServiceException;
    public void setShad(SHAD shad) throws ServiceException;

    public boolean hasAMSEWithinDateRange(Date fromDate, Date toDate) throws ServiceException;
    public boolean hasAMSEWithinDateRange(boolean useHECEnteredMSEDate,Date fromDate,Date toDate) throws ServiceException;

    public void setHECPeriodOfService(String pos) throws ServiceException;

	public void setVOAPeriodOfService( String pos ) throws ServiceException;

    public boolean hasVAMCEnteredMilitaryServiceEpisodes() throws ServiceException;
    public boolean hasVAMCEnteredMilitaryServiceEpisodesOnFile() throws ServiceException;

    public boolean hasHECEnteredMilitaryServiceEpisodes() throws ServiceException;

    public boolean hasHECMSEwithinDateRange(Person person, Date fromDate, Date toDate) throws ServiceException;

    public boolean hasHECEnteredMilitaryServiceEpisodesOnFile() throws ServiceException;

    public boolean isDataFromVSSC();

    public LoadVSSCDataResult getLoadVSSCDataResult();

    //vvvv    NDAA CV End Date requirements    vvvv
    public boolean isMostRecentConflictToDateAfter( Date date);

    public boolean hasNoEnrollRecordPriorNDAA(String ndaaDate)  throws ServiceException;

    public  Date getNDAADatePlus3YearsMinus1Day(String ndaaDate);

    public Date getMostRecentSSDOrCombatEndDatePlus5YearsMinus1Day();

    public Date getMostRecentSSDOrCombatToDate();
    //^^^^    NDAA CV End Date requirements    ^^^^

    // MSDS Support
    public boolean hasCombatService(Person person);
    public boolean hasCombatServiceWithOverlap(CombatService cs);
    public boolean hasCombatEpisodeWithOverlap(CombatEpisode ce);
    public boolean hasCombatEpisodeWithStartDateOnlyOverlap(CombatEpisode ce);
    public boolean hasDeployment(Person person);
    public boolean isCVEndDateImproved(Person incoming, Person onFile);
    public CombatService getCombatService();
    public void setMHDecorationStatus(String status) throws ServiceException;
    public void setMHIndicator(String indicator) throws ServiceException;
    public void setMHStatusUpdateDate(Date statusUpdateDate);
    public void setRAD(Date rad);
    public void acceptServiceEpisodeFromMSDS() throws ServiceException;
    public void updateActivation() throws ServiceException;
    public void updateCombatPayData();
    public void acceptCombatEpisodesFromVadir();
    public void updateCombatPayEndDate();
    public void updateDeploymentData() throws ServiceException;
    public void updateDeploymentEndDate();
 	public boolean hasCombatPayExactMatch(CombatService cp);
	public boolean hasCombatPayMatch(CombatPayType type, Date begin);
	public boolean hasDeploymentMatch(Date begin);
	public Deployment getDeployment();
	public boolean hasDeploymentExactMatch(Deployment deployment);
	public boolean hasMatchingBOSandBegDateOfServiceInADR(ServiceBranch branch, Date begin ) throws ServiceException;
	public boolean hasMultNonbreakServiceEpisode() throws ServiceException;
	public boolean hasMultNonbreakServiceEpisodeEQorGT24ContinuousMonths() throws ServiceException;
	public boolean hasServiceEpisodeExactMatch() throws ServiceException;
	public boolean hasServiceEpisodeWithOverlap(MilitaryServiceEpisode mse) throws ServiceException;
	public boolean hasSingleServiceEpisodeEQorGT24ContinuousMonths() throws ServiceException;
	// START CCR 11570
	public boolean isMilitaryServiceEpisodeEQorGT24Months(MilitaryServiceEpisode mse) throws ServiceException;
	public boolean isAnyMilitaryServiceEpisodeEQorGT24Months(Set episodes) throws ServiceException;
	public boolean isCharacterOfDischargeOfLastNonbreakServiceEpisodeEqual(String code, Set episodes) throws ServiceException;
	public boolean isPeriodOfServiceAtLeastOneDay(MilitaryServiceEpisode mse) throws ServiceException;
	public Set getFilteredMseSet();
	public void addFilteredMse(MilitaryServiceEpisode mse);
	public void removeAllFilteredMse();
	public String getMseCreatedBy();
	public void setHasQmse(boolean value);
	public void setMsdsMessageDate();
	// END CCR 11570
	public boolean isCharacterOfDischargeOfFirstNonbreakServiceEpisodeEqual(String code) throws ServiceException;
	public boolean isCharacterOfDischargeOfLastNonbreakServiceEpisodeEqual(String code) throws ServiceException;
	public boolean isCombatPayPeriodLessThan(Date start, Date end);
	public boolean isCombayPayPeriodLessThanADR(Date start, Date end);
	public CombatPayType getCombatPayType();
	public MsdsCountry getDeploymentCountry();
	public Date getActivationEndDate();
	public Date getMostRecentActivationEndDate();
	public Date getActivationEndDate(Person person);
	public Date getCombatPayEndDate();
	public Date getMostRecentCombatPayEndDate();
	public Date getCombatPayEndDateADR();
    public Date getCombatPayStartDate();
	public Date getDeploymentBeginDate();
	public Date getDeploymentEndDate();
	public Date getDeploymentEndDate(Person person);
	public Date getEnteredOnDuty();
	public Date getMostRecentHECrecordSSD();
	public Date getRADDate();
	public Date getMatchedRADDate();
	public DischargeType getServiceDischargeType(Person person);
	public DischargeType getMsdsServiceDischargeType();
	public ServiceBranch getMsdsServiceBranch();
	public MHDataSource getDeploymentSourceOfData();
	public CombatServiceSource getCombatPaySourceOfData();
	public MilitaryServiceEpisode getMSEFromMSDS();
    public String getMsdsServiceComponent();
    public String getHECMostRecentServiceComponent();
    public String getMsdsWorkItem();
    public void setMsdsWorkItem(String item);
	public String getActivationTerminationReasonCode();
	public String getCharacterOfServiceCode();
	public String getCombatServiceSourceCode();
	public String getMedalOfHonorIndicator(Person person) throws ServiceException;
    public String getMostRecentCombatLocation(Person person);
	public String getNameContingencyCode();
	public String getSpecialOperationCode();
	public String getTerminationReasonCode();
	public String getMSDSdataSource();
	public void acceptMHFromMSDS() throws ServiceException;
	public void acceptOrDeleteMH() throws ServiceException;
	public void adjustMSDSImpreciseDates();
	public void setCharacterOfDischarge(DischargeType type);
	public void setCombatPaySourceOfData(CombatServiceSource source);
	public void setCombatPayDateLastUpdated();
	public void setMatchedCombatEpisodeEndDate();
	public void setDeploymentDateLastUpdated();
	public void setDeploymentSourceOfData(MHDataSource source);
	public void setMHDataSource(String dataSource) throws ServiceException;
	public void setMHDocumentReceiptDate(Date receiptDate);
	public void setMHDocumentType(String documentType) throws ServiceException;
	public void setMHLastEditedDate(Date receiptDate);
	public void setServiceEndDate();
	public void setServiceEpisodeDateLastUpdated();
	public void setServiceEpisodeSourceOfData();
	public Activation getActivation();
	public CombatEpisode getCombatEpisode();
	public void setCombatEpisode(CombatEpisode combatEpisode);
    public Date getHECMostRecentSSDOrCombatToDate();
    public Date getHECMostRecentDtSsdCombatEpisodeActivationCombatPay();
    public Date getHECMostRecentReceivedSSD();
    public boolean isHECMostRecentConflictToDateAfterForLocation(Date date, String conflictLocation);
    public Date getHECMostRecentSSDOrCombatEndDatePlus5YearsMinus1Day();
	public void setMsdsQueryStatus(String status) throws ServiceException;
	public String getMsdsQueryStatusCode(Person person);
	public void terminateRuleFlow(boolean flag);
	public String getMsdsReceiveStatus();
	public String getMsdsVadirStatus();
	public String getMsdsBirlsStatus();
	public String getMsdsOefOifIndicator();
	public void setOefOifIndicatorOfMostRecent(String ind) throws ServiceException;
	public boolean hasDeploymentWithOverlap(Deployment deployment);
	public boolean getServiceIndicator() throws ServiceException;
	public boolean hasQmse();

	//---- 9385 Refactoring--------------------
	public void setActivation(Activation activation);
	public Set getActivations();
	public Set getCombatEpisodes();
	public void setDeployment(Deployment deployment);
	public void setCombatPay(CombatService combatPay);
	public Set getCombatPays();
	public void setMilitaryServiceEpisode(MilitaryServiceEpisode mse);
	public Set getHECMilitaryServiceEpisodes() throws ServiceException;
	public Set getHECMilitaryServiceEpisodesResult() throws ServiceException;
	public void setMSDSdataSource(String source);
	public boolean isMsdsRetryCountGreaterThanLimit() throws ServiceException;
	public boolean hasNewMilitaryServiceEpisode();
	public boolean hasNewOEFOIFdata();
	public boolean hasNoMSDSdata();
	public void setMatchedActivation(Activation matchedActivation);
    public DischargeType getMatchedServiceDischargeType();
    public String getMatchedServiceDischargeTypeCode();
    public void setImpreciseData(boolean isImprecise);
    public boolean hasImpreciseData();
    public void acceptPreciseServiceEpisodeFromMSDS() throws ServiceException;
    public boolean hasMatchingImpreciseDate() throws ServiceException;
    public boolean isImprovedByMSDS();
    public boolean isProcessQMSEflow();
	//------------------------
    // End of MSDS Support
	//Seeding
	public boolean getSeedingIndicator();
	public void updateSeedingCombatEpisodes() throws ServiceException;
    public void setSeedingMilitaryServiceSiteInformation() throws ServiceException;
    public boolean updateSeedingCVEndDate();
    public boolean isHecTransfer();
    public void createHECFromIncoming() throws ServiceException;
    public boolean isDischargeDueToDisabilityChanged();

    //CCR 11469
    public MsdsCountry getMsdsCountryCode();
    //CLV
    public boolean isResultCLVeligible();
    public boolean isResultCLVeligibleNoVeteran();
    public boolean isResultVeteran();
    public boolean isPristineCLVeligibile();
    public boolean isIncomingCLVeligibile();
    public boolean calculateCLVeligibilitybyMSE(Person p);
    public boolean calculateCLVeligibilitybyMSENoVeteran(Person p);
    public boolean isCLVEligibleSamePOn();
    public boolean isCLVEligibleNoToYesPOn();
    public boolean  isResultCLVeligibleForNoHEC();
    public boolean  isResultCLVeligibleForNoHECNoVeteran();

}