/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule;

// Java classes
import java.util.Map;
import java.util.Set;

// Library classes

// Framework classes

// ESR classes
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.service.trigger.PersonTrigger;

/**
 * @author Carlos Ruiz
 * @version 1.0
 */
public interface MessageEventInput extends BaseInput, PersonTrigger { 
	// Add methods here to get data elements
	public void queryVBAForEligibility();
	public void respondVistaForEligibility();
	public void notifyVistaForEligibility();
	public void queryVistaForFullData();
	public void notifyVistaForInsurance( Set updatedKeys );
	public void notifyVistaForAddress( Map updatedKeysAndSites ); 
    public void notifyVistaForAddress();   
	public void notifyVistaForAddress(VAFacility sendingFacility, String dfn);
	public void notifyVistaForAssociation(Map updatedKeys); 
	public void notifyVistaForSpouseDependentsSSNValidationInfo();
	public void notifyVistaForFinancial();
	public void notifyVistaForIVMFinancial();	
	public void notifyVistaForFinancialByIncomeYear(Integer incomeYear);	
    public void notifyVistaForIncomeTestDelete();
	public void respondVistaForFinancial();
	public void notifyVistaForDateOfDeath(); 
	public void notifyVistaForDateOfDeath(VAFacility sendingFacility);
	public void generateORFZ10(VAFacility facility, String dfn, Integer incomeYear);
	public void generateORFZ11(VAFacility facility, String dfn);
	public void notifyVistaForSignatureInformation();
    public boolean isZ10Sent();	
    public void notifyVistaForFinancialExceptPrimary();
    public void notifySendingVistaForFutureDatedTest(VAFacility facility, String dfn);
	public void queryMSDSforMSdata();  
	public boolean getQueryMSDSIndicator();
	public boolean isValidQueryInfo();
}
