/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule;

// Java classes
import gov.va.med.esr.common.model.ee.MedicaidFactor;

import java.util.Date;


// Library classes

// Framework classes

// ESR Classes
import gov.va.med.esr.common.model.person.Person;

/**
 * @author Carlos Ruiz
 * @version 1.0
 */
public interface MedicaidInput extends BaseInput {
    public MedicaidFactor getMedicaidFactor();
    public MedicaidFactor getResultMedicaidFactor();
    public boolean isEligibleForMedicaid();
    public Date getDateMedicaidLastUpdated();
    public boolean isResultEligibleForMedicaid();
    public Date getResultDateMedicaidLastUpdated();
    public void updateMedicaidFacotr();
    // CR 9803 and CCR 10023 changes
    public boolean isEligibleForMedicaid(Person person);   
    public boolean isEligibleForMedicaidChanged();
}