/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule;

// Java classes
import gov.va.med.esr.common.model.insurance.InsurancePolicy;

import java.util.Date;


// ESR Classes

/**
 * @author Carlos Ruiz
 * @version 1.0
 */
public interface InsuranceInput extends BaseInput {
    public Date getInsuranceEffectiveDate();

    public Date getInsuranceExpirationDate();
    
    public boolean getEnrolledInPartA();
    
    public boolean getEnrolledInPartB();
    
    public Date getPartAEffectiveDate();
    
    public Date getPartBEffectiveDate();
    
    public String getMedicareClaimNumber();
    
    public String getNameOnMedicareCard();
    
    public String getInsuranceReportSource();
    
    public String getInsurancePolicyType();
    
    public boolean isInsurancePolicyTypeForMedicare();
    
    public String getRelationshipToInsured();
    
    public String getNameOfInsured();
    
    public void setNameOfInsured(String name);
    
    public void setInsuranceCompanyName (String name);
    
    public void setGroupNumber (String groupNumber);
    
    public void setGroupName (String groupName);
    
    public void setEnrolledInMedicarePartA(boolean b);
    
    public InsurancePolicy getResultInsurancePolicy();
    
    public void setEnrolledInMedicarePartB(boolean b);
    
    public boolean isInsurancePolicyOnFile();
    
    public void mergeInsurancePolicy();
    
    public void addInsurancePolicy();
    
    public String getAddressZipCode();
    
    public String getPristineAddressZipCode(); 
    
    public boolean isInsuranceAddressFound();
    
    public String getInsuranceCompanyName();
}
