/*****************************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ****************************************************************************************/
package gov.va.med.esr.common.rule;

// Java classes
import java.util.Date;

// Framework classes
import gov.va.med.fw.rule.RuleException;

// ESR Classes
import gov.va.med.esr.common.model.ee.IneligibilityFactor;
import gov.va.med.esr.common.model.person.Person;

/**
 * This interface gets mapped to a virtual class in ILOG.
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public interface IneligibleInput extends BaseInput {

   public Date getIneligibilityDate(Person person) throws RuleException;
   public Date getIneligibilityDate() throws RuleException;
   public void setIneligibilityDate( Date date ) throws RuleException;

   public IneligibilityFactor getIneligibilityFactor() throws RuleException;
   public IneligibilityFactor getIneligibilityFactor( Person person ) throws RuleException;

   public String getIneligibilityReason() throws RuleException ;
   public String getIneligibilityReason( Person person ) throws RuleException ;
   public void setIneligibilityReason( String reason ) throws RuleException ;

   public String getIneligibilityVARODecision() throws RuleException ;
   public String getIneligibilityVARODecision( Person person ) throws RuleException ;
   public void setIneligibilityVARODecision( String decision ) throws RuleException ;
   
   public String getIneligibleDateReceivedFrom()throws RuleException;
   
   public void setIneligible(IneligibilityFactor ineligible) throws RuleException;
   
   public void updateIneligibility() throws RuleException;
   public void removeIneligibility();

   public boolean isUpdateFromSiteViaZ07()throws RuleException;
   public boolean isIneligibleDateUpdatedByVAMC()throws RuleException;


}