/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.rule;

// Java classes
import gov.va.med.esr.common.model.financials.BeneficiaryTravel;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.Hardship;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.PatientVisitSummary;
import gov.va.med.esr.common.model.lookup.IncomeTestSource;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.parameter.MTTotalIncomePresentAndFinancialStmtIncomeNullException;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author DNS   MANSOG
 * @author Carlos Ruiz
 * @version 1.0
 */
public interface FinancialInput extends FinancialInfoInput {    

	// START CCR 10535 - Fix Spouse Employment issues
 	public void setSpouseOccupation(Employment incoming, Employment result);
 	public void setSpouseEmployerAddressLine1(Employment incoming, Employment result);
 	public void setSpouseEmployerAddressLine2(Employment incoming, Employment result);
 	public void setSpouseEmployerAddressLine3(Employment incoming, Employment result);
 	public void setSpouseEmployerAddressCity(Employment incoming, Employment result);
 	public void setSpouseEmployerAddressState(Employment incoming, Employment result);
 	public void setSpouseEmployerAddressZip(Employment incoming, Employment result);
 	public void setSpouseEmployerPhoneNumber(Employment incoming, Employment result);
 	public void setSpouseEmployerName(Employment incoming, Employment result); 	
 	public void setSpouseDateOfRetirement(Employment incoming, Employment result);
 	public void setSpouseEmploymentStatus(Employment incoming, Employment result);
    public Employment getPristineSpouseEmployment(); 	
 	// END CCR 10535 - Fix Spouse Employment issues 	
 	
 	
    public boolean ifConditionsMetMakeFutureTestEffectiveImmediately() throws ServiceException;
    public boolean isIncomingVeteranIncomeNull();
    public BigDecimal getIncomingIncomeTestTotalIncome();
    public boolean isIncomingVeteranSpouseIncomeNull();
    public boolean isIncomingVeteranDependantsIncomeNull();
    public void throwMTTotalIncomePresentAndFinancialStmtIncomeNullException() throws MTTotalIncomePresentAndFinancialStmtIncomeNullException;
    /**
     * 
     * @return threshold as a big decimal. this method was created so that it
     *         returned the proper data type as declared in the database.
     * @throws ServiceException
     */
    public BigDecimal getCalculatedGMTThresholdAsBigDecimal()
            throws ServiceException;

    public boolean isIncomingIncomeTestYearGreaterThanCurrentYear();
    
    public boolean isFinancialStatementCopied();

    public void setFinancialStatementCopied(boolean financialStatementCopied);

    public boolean isIncomeTestCopied();

    public void setIncomeTestCopied(boolean incomeTestCopied);

    public void setMeansTestStatus(String statusCode)
            throws UnknownLookupTypeException, UnknownLookupCodeException;

    public void setMeansTestStatus(String statusCode,
            String determinedStatusCode) throws UnknownLookupTypeException,
            UnknownLookupCodeException;

    public void setMeansTestStatus(IncomeTest test, String statusCode,
            String determinedStatusCode) throws UnknownLookupTypeException,
            UnknownLookupCodeException;

    public void setPharmacyTestStatus(String statusCode)
            throws UnknownLookupTypeException, UnknownLookupCodeException;

    public void setPharmacyTestStatus(String statusCode,
            String determinedStatusCode) throws UnknownLookupTypeException,
            UnknownLookupCodeException;

    public void setPharmacyTestStatus(IncomeTest test, String statusCode,
            String determinedStatusCode) throws UnknownLookupTypeException,
            UnknownLookupCodeException;

    public void setIncomeTestType(String typeCode)
            throws UnknownLookupTypeException, UnknownLookupCodeException;

    public void setIncomeTestType(IncomeTest test, String typeCode)
            throws UnknownLookupTypeException, UnknownLookupCodeException;

	public void setSiteConductingTest(VAFacility facility);

    public String getCalculatedMeansTestStatusCode() throws ServiceException;

    public String getCalculatedRxCopayStatusCode() throws ServiceException;

    public boolean isIncomeTestDeleted();
	
	public void deletePrimaryIncomeTest();
		
    public IncomeTestSource getIncomeTestSource(IncomeTest incomeTest);

    public String           getIncomeTestSourceCode(IncomeTest incomeTest);
	
    
	public boolean isIncomeTestDeleted(String source);
   
    public String getMeansTestStatusCode(IncomeTest incomeTest,
            IncomeTestType.Code testType);

    public String getMeansTestStatusCode();

    public String getPharmacyCopayStatusCode();

    public String getMeansTestStatusCode(IncomeTest incomeTest);

    public String getPharmacyCopayStatusCode(IncomeTest incomeTest);    

    public String getMeansTestDeterminedStatusCode(IncomeTest incomeTest);

    public String getPharmacyCopayDeterminedStatusCode(IncomeTest incomeTest);       
    
    public void setIncomeTest(IncomeTest incometest) throws ServiceException ;

    public void processIVMIncomeTest() throws ServiceException;

    public String getSiteConductingTestFacilityCode(IncomeTest iTest);

    public VAFacility getSiteConductingTest(IncomeTest iTest);

    public Boolean hasMarriedLastCalendarYear();

    public void setLivedWithPatient(Boolean flag);

    public BigDecimal getSpousalSupportAmount();
         
    public String getMTStatus();
    
	public String getIncomeTestTypeCode(IncomeTest test);
			
	public Date getCompletedDate();

	public void setCompletedDate(Date date);

    public void setCompletedDate(IncomeTest incomeTest, Date date);

	public Date determineCompletedDate();

	public Date getEffectiveTestDate();

	public void setEffectiveTestDate(Date date);

	public Date determineEffectiveDate();

	public Date getIncomeTestLastEditedDate();

	public Date getPristineIncomeTestLastEditedDate();

	public Date getCompletedDate(IncomeTest incomeTest);

	public Date getEffectiveTestDate(IncomeTest incomeTest);

	public Date getLastEditDate(IncomeTest incomeTest);

	public void setLastEditDate(Date date);

	public Boolean getCADAdjusted(IncomeTest test);

	public void setCADAdjusted(Boolean cadAdjusted);

	public Boolean getAgreeToPayIndicator(IncomeTest test);
	
	// CCR 12054 support PG8 ind from IVM
	public boolean getPg8RelaxationIndicator(IncomeTest test);	
    public boolean hasNoPriorIYTestOrAllPriorTestsMTCopayRequired() throws ServiceException;
    public boolean checkForPresenceOfIVMIncomeTestMeetingP8RecheckCriteria() throws ServiceException;
    public String getIVMActionCode();
    public void createCloneIncomeTest() throws ServiceException;
    public void createOrUpdateTestFromIVMConversionData(boolean testExists) throws ServiceException;
    public void reverseExistingMeansTest() throws ServiceException;
    public void reverseDoesNotExistMeansTest() throws ServiceException;
    public boolean wasConversionToExistingMeansTest(Integer incomeYear) throws ServiceException;
    public boolean hasIVMTestOnFileForIncomingIY() throws ServiceException;
    // CodeCR13147_CR_Receive Beneficiary Travel Financial Indicator in ES
    public void updateBTFinancialInd();
    // IVM needs to be notified of certain changes to finacials. The following two methods detect the
    // changes for subsequent processing by advice.
    public void addIncomeTestDeletedEvent();
	public void postProcessIVMEvents();    
    
	public void setAgreeToPayIndicator(Boolean atpd);

    public Boolean getDisclosure(IncomeTest test);

    public String getDisclosure();

	public void setDisclosure(Boolean disclosure);

    public String getDeductibleStatus();
    
    public IncomeTest getMostRecentIncomeTest() throws ServiceException;

    public Integer getCurrentIncomeTestYear(Person person)
            throws ServiceException;

    public IncomeTest getCurrentIncomeTest() throws ServiceException;

    public IncomeTest getCurrentIncomeTest(Person person)
            throws ServiceException;

    public IncomeTest getCurrentIncomeTestForEE(Person person)
            throws ServiceException;

	//Methods added by Madhu
	public boolean isCADAdjusted ();

	public boolean isCADAdjusted (IncomeTest incomeTest);
	
	public boolean isAgreetoPayCoPay();

	public boolean isAgreetoPayCoPay(IncomeTest incomeTest);

	public boolean isTestTypeMeansTest ();

	public boolean isTestTypeMeansTest (IncomeTest incomeTest);
	
	public String getDeterminedStatus();

	public String getDeterminedStatus(IncomeTest incomeTest);
	
	public boolean isDuplicateIncomeTest();	

	public boolean isIncompleteIncomeTest();

	public boolean isIncompleteIncomeTest(IncomeTest incomeTest);

	public boolean isIncomingTestDeterminedPrimary ();

    public boolean getDeterminedPrimaryFlag();

    public void setDeterminedPrimaryFlag(boolean flag);
    
    public boolean isDataFromZ07();
    
    public void setDataFromZ07(boolean isDataFromZ07);


	public IncomeTest getIncomeTest();	

	public IncomeTest getPristineIncomeTest();
	
	public IncomeTest getResultIncomeTest();

	public void setPrimaryInd(IncomeTest test, Boolean primary);

	public boolean isPrimary(IncomeTest test);
	
	public Date addYearToDate(Date currentDate);

	public boolean processEffectiveImmediately() throws ServiceException;

	public boolean isHardShipGranted();

	public Hardship getHardship(IncomeTest incomeTest);

	public void setHardship(Hardship hardship) throws ServiceException;

    public Date getHardshipEffectiveDate();

    public Date getHardshipEffectiveDate(IncomeTest incomeTest);

    public String getSiteGrantingHardship(IncomeTest incomeTest);

    public void processHardship() throws ServiceException;
    
    public void processBeneficiaryTravel()  throws ServiceException;

    public BeneficiaryTravel getBeneficiaryTravel(Person person);

    public void setBeneficiaryTravel(BeneficiaryTravel bt);	

    //BT method used by E&E
    public Date getDateOfLastVisit();

    public void processPatientVisitSummary() throws ServiceException;    

    public PatientVisitSummary getPatientVisitSummary(Person person);

    public void setPatientVisitSummary(PatientVisitSummary pvs);	

    public void mergeIncomeTestStatus(IncomeTestType.Code typeCode)
            throws ServiceException;

    public void processFinancialStatement() throws ServiceException;

    public void setFinancialStatement(FinancialStatement stmt)
            throws ServiceException;

    public void setValidDependent(FinancialStatement stmt);

    public void setNumberOfDependentChildren(Integer numberOfDependentChildren);

    public void setNumberOfDependents(Integer totalNumberOfDependents);

    public Integer getCalculatedNumberOfDependentChildren();

    public Integer getCalculatedNumberOfDependents();

    public BigDecimal getCalculatedTotalIncome() throws ServiceException;

    public void setTotalIncome(BigDecimal income) throws ServiceException;
    
    public BigDecimal getCalculatedNetIncome() throws ServiceException;
    
    /**
     * Method for getting Net Income from an income test within context
     * of evaluating continuous enrollment. Should not be used by financials. 
     *  
     * @return
     * @throws ServiceException
     */
    public BigDecimal getCalculatedNetIncomeForCE() throws ServiceException;    

    public void setNetIncome(BigDecimal income) throws ServiceException;

    public void setNetworth(BigDecimal networth);

    public BigDecimal getCalculatedNetworth();

    public BigDecimal getCalculatedDeductibleExpense() throws ServiceException;    

    public void setDeductibleExpense(BigDecimal expense);
    
    public BigDecimal getCalculatedIncomeExclusionThreshold()
            throws ServiceException;

    public void setIncomeExclusionThreshold(BigDecimal threshold);
    
    public BigDecimal getCalculatedAdjustableMedicalExpense()
            throws ServiceException;

    public void setAdjustableMedicalExpense(BigDecimal expense);
    
    public BigDecimal getCalculatedNonReimbursedMedicalExpense()
            throws ServiceException;

    public void setNonReimbursedMedicalExpense(BigDecimal expense);
    
    public BigDecimal getCalculatedNetworthThreshold() throws ServiceException;    

    public void setNetworthThreshold(BigDecimal threshold);

    public BigDecimal getCalculatedPensionThreshold() throws ServiceException;    

    public void setPensionThreshold(BigDecimal threshold);

    public Integer getMTThreshold();

    public Integer getMTThreshold(IncomeTest test);

    public BigDecimal getCalculatedMTThreshold() throws ServiceException;

    public void setMTThreshold(BigDecimal threshold);

    public Integer getGMTThreshold();

    public Integer getGMTThreshold(IncomeTest test);

	public Integer getCalculatedGMTThreshold() throws ServiceException;

	public void setGMTThreshold(Integer threshold);

    public Address getCalculatedGMTAddress() throws ServiceException;

	public Address getGMTAddress(IncomeTest test);

	public void setGMTAddress(Address address);

	//Can financials be Added/Edited decistion table required methods 
    public boolean isIncomeTestCurrent() throws ServiceException;

    public boolean isCurrentTestOlderThan365Days () throws ServiceException;

    public boolean isMTPermitted();

    public void setMTPermitted(boolean value);
    
    public boolean isRXCopayApplicableForVeteran();

    public void setRXCopayApplicableForVeteran(boolean copayApplicableForVeteran);

    public boolean isVeteranSubjectToMeansTesting() throws ServiceException;

    public void setVeteranSubjectToMeansTesting(
            boolean veteranSubjectToMeansTesting);

    public boolean isAllowedtoEditCurrentTest() throws ServiceException;

    public boolean isAllowedtoAddMeansTest() throws ServiceException;

    public boolean isAllowedtoAddPharmacyCopayTest() throws ServiceException;

    public boolean isAllowedtoAddTest() throws ServiceException;
	
    public MeansTestStatus determineMeansTestStatus() throws ServiceException;

	public boolean isAdjudicationResponseRequired() throws ServiceException;
    
    public String getReceivingFacilityCode();

    public VAFacility getReceivingFacility();
    
    public BigDecimal getDebtAmount();

    public boolean isDebtInRange(double lower, double upper);
    
    public BigDecimal getAdd90DayHospitalMedicareDeductible()
            throws RuleException;
   
    public BigDecimal getOutpatientSpecialCopay() throws RuleException;

    public BigDecimal getAdd90DayHospitalDeductible() throws RuleException;
    
    public BigDecimal getNinetyDayHospitalCopay() throws RuleException;

    public BigDecimal getGMTInpatient90DayCopay() throws RuleException;

    public BigDecimal getGMTInpatientAdd90DayCopay() throws RuleException;

    public BigDecimal getGMTInpatientPerDiem() throws RuleException;

    public BigDecimal getOutpatientPreventiveCopay() throws RuleException;

    public BigDecimal getOutpatientCopay() throws RuleException;

    public BigDecimal getMedicationCopay() throws RuleException ;

    public BigDecimal getInpatientPerDiem() throws RuleException;
  
    public Integer getIncomeYear(IncomeTest incomeTest);

    public String getPriorMeansTestStatusCode() throws RuleException;

    public String getPriorPharmacyCopayStatusCode() throws RuleException;
    
    public Date getDateRefusedCopay() throws RuleException;
    
    public void convertMTToRxCopayTest() throws RuleException;

    public void convertToMT() throws RuleException;    

    public String getPristineMeansTestStatus(); 

    public Boolean getSpouseLivesWithVeteran();

    public void updateLTCStatuses() throws ServiceException;
    
    //P8 New Methods
    public boolean isIncomeGreaterThanMTTplusRelaxPercent(float relaxPercent) throws ServiceException;
    public boolean isIncomeGreaterThanGMTplusRelaxPercent(float relaxPercent) throws ServiceException;
    public boolean isIncomeGreaterThanGMTplusRelaxPercentForCE(float relaxPercent) throws ServiceException;
    public boolean isIncomeGreaterThanMTTplusRelaxPercentForCE(float relaxPercent) throws ServiceException;    
    
    // Maint fixes
    public boolean hasTestonfileForIncomingIncomeYear() throws ServiceException;
    // CodeCR10023 - CR9803
    public boolean hasVerifiedEnrollmentAndP8Eligible() throws ServiceException;
    //  CR9803
    /** Returns the relaxation percentage for the specified income year */
    public float getRelaxPercentage(Integer incomeYear) throws ServiceException;
    /** Returns the relaxation percentage for the current income year */
    public float getRelaxPercentage() throws ServiceException;
    // CodeCR10023 - CR9803    
    public boolean checkForPresenceOfIncomeTestMeetingP8RecheckCriteria() throws ServiceException;
     
    public IncomeTest getPristinePrimaryIncomeTest();

    public void setSubjectToOrPermittedTrue();
	
    public boolean hasIncomingSpouse();   
    public Employment getIncomingSpouseEmployment();
    public Employment getResultSpouseEmployment();
    public boolean isPersonFromVISTA();
    public boolean isSpouseAddressAfter();
    public void updateSpouseAddress() throws ServiceException;
    public boolean isSpouseHomePhoneAfter();
    public void updateSpouseHomePhone() throws ServiceException;
	public void saveInProcessInfo(Person person, Integer incomeYear ) throws RuleException, ServiceException;

  public boolean hasPrimaryMeansTest();
  public boolean isVoaDiscloseFinancialDataNo() throws UnknownLookupTypeException, UnknownLookupCodeException;
  public void preProcessVOAFinancialData() throws RuleException;
  

    /**
     * The test made effective must be indentified previously and saved in FinancialInputData object
     * otherwise a call to this method is a NOOP.
     */
    public void makeExistingFDTEffectiveImmediately() throws ServiceException;
    /**
     * This method returns an existing FDT that was indentified previously
     */
    public IncomeTest getExistingFDT() throws ServiceException;    
    
    public boolean isPharmacyCopayStatusChanged() throws ServiceException ;
    public boolean isMTCopyStatusChanged() throws ServiceException ;
	public IncomeTest getIncomeTestFutureTestIncluded();

    
}