/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule;

// Java classes
import java.math.BigDecimal;
import java.util.Date;

import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.lookup.AssetType;
import gov.va.med.esr.common.model.lookup.ExpenseType;
import gov.va.med.esr.common.model.lookup.IncomeType;
import gov.va.med.esr.common.model.person.Person;

/**
 * @author DNS   MANSOG
 * @version 1.0
 */
public interface FinancialInfoInput extends BaseInput {
    public FinancialStatement getFinancialStatement(Person person, Integer incomeYear);
    public IncomeTest getIncomeTest(Person person, Integer incomeYear);
    public Integer getIncomingIncomeYear();

    public BigDecimal getAssetAmount(AssetType.Code expenseType);
    public BigDecimal getIncomeAmount(IncomeType.Code expenseType);
    public BigDecimal getExpenseAmount(ExpenseType.Code expenseType);
    
    public boolean isIncomeInRange(double lower, double upper);
    public boolean isExpenseInRange(double lower, double upper);
    public boolean isAssetInRange(double lower, double upper);
    
    //Generic/utility methods
    public Date getLatest(Date date1, Date date2);
    public Date getEarliest(Date date1, Date date2);
    public boolean isEarlier(Date date1, Date date2);
}