package gov.va.med.esr.common.rule;
import gov.va.med.esr.common.model.lookup.FeeBasisProgram;
import gov.va.med.esr.common.model.lookup.FeeBasisTreatmentType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.service.ServiceException;

import java.util.Date;


/**
 * @author DNS   SHARIA
 */
public interface FeeBasisProgramInput extends BaseInput {

	/**
	 * Get FeeBasisProgram type for a given person's FeeBasis.
	 * @param p - a Person
	 * @return FeeBasisProgram
	 */
	//public FeeBasisProgram getFeeBasisProgram(Person p);
    public FeeBasisProgram getFeeBasisProgram();
    public FeeBasisProgram getVeteranFeeBasisProgram();
	
	/**
	 * Get FeeBasisTreatmentType type for a given person's FeeBasis.
	 * @param p - a Person
	 * @return FeeBasisTreatmentType
	 */
	//public FeeBasisTreatmentType getFeeBasisTreatmentType(Person p);
    public FeeBasisTreatmentType getFeeBasisTreatmentType();
    public FeeBasisTreatmentType getVeteranFeeBasisTreatmentType();
	
	/**
	 * Get fee basis authorization from date for a given person.
	 * @param p - a Person
	 * @return Date - authroization from date
	 */
	//public Date getAuthorizationFromDate(Person p);
    public Date getAuthorizationFromDate();
    public Date getVeteranAuthorizationFromDate();
	
	/**
	 * Get fee basis authorization to date for a given person.
	 * @param p - a Person
	 * @return Date - authroization to date
	 */
	//public Date getAuthorizationToDate(Person p);
    public Date getAuthorizationToDate();
    public Date getVeteranAuthorizationToDate();    
	
	/**
	 * Merge the incoming fee basis object to existing one.
	 * @throws ServiceException 
	 */
	public void mergeFeeBasisProgram() throws ServiceException;
	
	/**
	 * Get the VAFacility that sent the message.
	 * @param p - a Person
	 * @return VAFacility - a va facility site
	 */
	public VAFacility getSendingFacility();
    public VAFacility getReportingFacility();	
}
