/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.rule;

// Java classes
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.ReceivedEligibility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.data.EventInputData;

import gov.va.med.fw.rule.RuleConfigurationException;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;

import java.util.Date;

/**
 * @author Carlos Ruiz
 * @version 1.0
 */
public interface EnrollmentInput extends BaseInput {
    public boolean isMostRecentEnrollmentEffectiveDateYearEqualToThisYear() throws RuleException;
    public Date getEffectiveDateForEarliestVerifiedUnlessCancelled()
    throws RuleException;
	public EnrollmentDetermination getCalculatedEnrollmentDetermination()
			throws RuleException;
	public boolean isTodayGreaterThanOrEqualToRegulationDate() throws RuleException;
	 public String getCalculatedEnrollmentStatus() throws RuleException ;
    public boolean getVeteranIndicator();
    public boolean getResultVeteranIndicator();
    public boolean getPristineVeteranIndicator();
    public String getIncomingPrimaryEligibilityCode() throws RuleException;
	public void setEnrollmentPriority(String value) throws RuleException;
	public boolean hasVeteranHadNoHealthBenefitPlan();
	public void updateHealthBenefitProfile() throws RuleException;
    public void addHBPToList(String hbpCodeStr) throws RuleException;
    public void removeHBPFromList(String hbpCodeStr) throws RuleException;
   
	/**
	 * Check if the veteran has specific received eligibility code.
	 * 
	 * @param eligibilityCode
	 *           The received eligibility code.
	 * @return
	 */
	public boolean hasReceivedEligibilityCodeEqualTo(String eligibilityCode);

	/**
	 * This method returns the calculated primary eligibility code. The ILOG
	 * rules should use this when they need to look at the currently calculated
	 * value.
	 * 
	 * @return the calculated primary eligibility code
	 */
	public String getCalculatedPrimaryEligibilityCode() throws RuleException;

	/**
	 * This method sets the result object with the calculated primary eligibility
	 * code.
	 * 
	 * @param value
	 * @throws RuleException
	 */
	public void setPrimaryEligilityCode(String value) throws RuleException;

	public void addToSecondaryEligibilityList(String value) throws RuleException;

	public void addToOtherEligibilityList(String value) throws RuleException;

	public void setSubPriority(String code) throws RuleException;

	public String getReceivedPrimaryEligibilityCode();

	public Date getReceivedEnrollmentDate();

	public Date getReceivedEnrollmentEffectiveDate();

	public Date getApplicationDate();

	public Date getApplicationDateFromVAMC();

	public String getReceivedEnrollmentStatus()
			throws RuleConfigurationException;

	public String getCancelledDeclinedReason();
	
	public String getCancelledDeclined();

	public Date getCancelledDeclinedDate();

	public String getPrimaryEligibilityCodeFromSite() throws RuleException;

	/**
	 * Set the enrollment date on the calculated enrollment.
	 * 
	 * @param enrollmentDate
	 */
	public void setEnrollmentDate(Date enrollmentDate) throws RuleException;

	/**
	 * Set the enrollment end date on the calculated enrollment.
	 * 
	 * @param enrollmentEndDate
	 */
	public void setEnrollmentEndDate(Date enrollmentEndDate)
			throws RuleException;

	public void setEnrollmentCategory(String category) throws RuleException;

	public void setEnrollmentStatus(String enrollmentStatus)
			throws RuleException;

	public void setEnrollmentEffectiveDate(Date date) throws RuleException;

	public void setEnrollmentSource(String source) throws RuleException;

	public void setFacilityReceivedFrom(String facility) throws RuleException;

	public Date getEnrollmentEffectiveDateFromVAMC();

	public Date getEnrollmentEffectiveDate();

	public String getEnrollmentSourceFromMessage();

	public String getEnrollmentStatusFromVAMC();

	public String getEnrollmentPriorityFromVAMC();

	public String getEnrollmentSubPriorityFromVAMC();

	public Date getEnrollmentDateFromVAMC();

	public Date getEnrollmentEndDateFromVAMC();

	public String getEnrollmentPriority() throws RuleException;
    
    public String getEnrollmentPriority(Person person) throws RuleException;    

	public String getEnrollmentSubPriority() throws RuleException;

	public Date getEnrollmentDate();

	public String getEnrollmentStatus() throws RuleException;

	public Date getPreviousEnrollmentDate() throws RuleException;

	public String getPreviousEnrollmentPriority();
	
	public String getEnrollmentPriorityBeforePH() throws RuleException;

	public String getPreviousEnrollmentSubPriority();

	public String getPreviousEnrollmentStatus() throws RuleException;

	public Date getMostRecentUnverifiedApplicationDate() throws RuleException;

	public void setApplicationDate(Date adate);

	/**
	 * 
	 * @return True if the pristine person's enrollment status is Verified.
	 * @throws RuleException
	 */
	public boolean hasPreviousVerifiedEnrollmentStatus() throws RuleException;
	
	/**
	 * 
	 * @return True if the person has ever had a enrollment in the past with the status Verified 
	 * @throws RuleException
	 */
	public boolean hasPriorVerifiedEnrollmentStatus() throws RuleException;

	public void setFacilityReceivedToHEC() throws RuleException;

	public void removeVeteranReceivedEligibilityCodes();

	public void updateVeteranReceivedEligibilityCodes() throws RuleException;
    
    public void updateApplication() throws RuleException;
    
    public void updateReceivedEnrollment() throws RuleException;

	public boolean isContainedReceivedEligibilityCode(String codes);

	public boolean isContainedVeteranReceivedEligibilityCode(String codes);

	// new 7/23/05

	public Date getCurrentApplicationDateOnFile();

	public Date getCurrentEffDateOnFile();

	public String getCurrentEnrollmentStatusOnFile() throws RuleException;

	public Date getEarliestEnrollmentEffectiveDate() throws RuleException;
    
    public Date getEarliestVerifiedEnrollmentDate() throws RuleException;    

	public boolean hasEverHadVerifiedEnrollment() throws RuleException;

	public Boolean getEnrollmentOverridenOnFile();

	public void setEnrollmentOverriden(boolean b) throws RuleException;

	public String getCurrentPrimaryEligibilityCode();

	public Boolean getEnrollmentOverride();

	public Boolean getProcessOverrideFromEnrollmentOverride();

	public Boolean getSiteVerifiedEnrollment() throws RuleException;

	public void setProcessOverride(boolean b);

	public String getPrimaryEligibilityCodeOfVerifiedSite() throws RuleException ;

	public boolean isTypeOfPrimaryEligibilityCodeEqualTo( String vetType ) throws RuleException;
    
    public boolean isTypeOfReceivedPrimaryEligibilityCodeEqualTo(String eligibilityType) throws RuleException;
    
   public boolean isTypeOfSiteRecordEligibilityCodeEqual( Person person, String vetType )
      throws RuleException;
   
	public boolean doesCalculatedSecondaryEligibilityCodeContain(
			String eligibility) throws RuleException;

	public boolean doesCalculatedPrimaryOrSecondaryEligibilitiesContain(
			String eligibilityCode) throws RuleException;
	
	public String getEnrollmentCategory() throws RuleException;
	public boolean isCalculatedEnrPriorityLessThanEGTSetting()  throws RuleException;
	
	public String getCurrentEnrollmentPrioirity() throws RuleException;
	
	public String getPriorEnrollmentPriority() throws RuleException;
	public boolean isEnrollmentPriorityEqualToPrevious() throws RuleException;
	// CCR 8395
	public boolean isEnrollmentPriorityImproved(Person incoming, Person onFile ) throws RuleException;	
	public String getPriorEnrollmentStatus() throws RuleException;
	public Date getRecentEnrollmentEffectiveDate() throws RuleException;
    
    public Date getESRImplementationDate() throws RuleException;
    public Date getEnrollmentRegulationDate() throws RuleException;
    
    public boolean hasApplicationDatePriorToEGTEffectiveDate() throws RuleException;
    public boolean hasVerifiedEnrollmentWithCombatVeteran() throws RuleException;    
    public boolean eligForMedicaidChangedToNo365DaysAfterAppDt() throws RuleException;    
    public boolean eligForMedicaidChangedToNo365DaysAfterMedLastChgDt() throws RuleException;
    public boolean hasVerifiedEnrollmentWithAA() throws RuleException;    
    public boolean hasVerifiedEnrollmentWithHB() throws RuleException;    
    public boolean hasVerifiedEnrollmentWithVAPension() throws RuleException;
    public boolean hasVerifiedEnrollmentWithEligibleForMedicaid() throws RuleException;    
    public boolean hasVerifiedEnrollmentWithAOLocationDMZ() throws RuleException;    
    /*CCR8753*/ public boolean hasVerifiedEnrollmentWithAOLocationVietnam() throws RuleException;    
    /*CCR8753*/ public boolean hasVerifiedEnrollmentWithEC() throws RuleException;    
    public boolean hasVerifiedEnrollmentWithSC_GTE_10PERCENT() throws RuleException;    
    public boolean hasVerifiedEnrollmentWithMT() throws RuleException;    
    // CodeCR10023 & CR 9803
    public boolean hasVerifiedEnrollmentStatusAfterPeriodOfNoEnrollment() throws RuleException;
    // CodeCR10023 & CR 9803
    public String getMostRecentVerifiedEnrollmentPriority(Person person) throws RuleException;
    // CodeCR10023 & CR 9803
    public String getMostRecentVerifiedEnrollmentSubPriority(Person person) throws RuleException;
    // CodeCR10023 & CR 9803    
	public boolean hasEligibilityCodeEqualTo(String eligibilityCode, Person person);
    // CodeCR10023 & CR 9803	
	public boolean hasVeteranCompletedMeansTestForYearOfApplication(Person person);
	// CodeCR10023 - CR9803    
	public boolean hasIncomeTestThatPreviouslyMetRule15Criteria() throws RuleException;	
	
    /**
     * Get Enrollment Status from most recent enrollment per CE rules.
     * 
     * @return
     * @throws RuleException
     */
    public String getEnrollmentStatusForCE() throws RuleException;
    
    /**
     * Get Enrollment Effective date from most recent enrollment per CE rules.
     * 
     * @return
     */
    public Date getEnrollmentEffectiveDateForCE() throws RuleException;
    
    public Boolean getEnrollmentOverrideForCE() throws RuleException;    

    /**
     * For continuous enrollment only
     * 
     * @return
     * @throws RuleException
     */
    public boolean isEGTPriorityCEGreaterThanCurrEGT()  throws RuleException;
    
    public boolean isReceivedPrimaryEligibilityValid(ReceivedEligibility re)  throws RuleException;
    
    public ReceivedEligibility getReceivedPrimaryEligibility(Person person) throws RuleException;    
    
    public String getPriorNonNullPriority() throws RuleException;
    
    public boolean isEffDatePriorToESRImplDate() throws RuleException;    
    public boolean isVetAppDatePriorToRegDate() throws RuleException;
    public boolean isVetAppDateGTEToRegDate() throws RuleException;
    public boolean isEffDatePriorToRegDate() throws RuleException;
    public boolean isEffDateGTEToRegDate() throws RuleException;    
    
    public void removeAllEligibilityFactors() throws RuleException;

    public boolean isPHOnly(Person person) throws RuleException;
    public boolean isPOWOnly(Person person) throws RuleException;
    public boolean isSHADOnly(Person person) throws RuleException;
    public EventInputData getEventInputData();
    
    //Methods for P8 changes.
    public void setInitialEnrollmentPriority(String code) throws RuleException;
    public void setInitialSubPriority(String code) throws RuleException;
    public String getEarliestEnrollmentPriority(Person person) throws RuleException;
    public String getEarliestEnrollmentSubPriority(Person person)throws RuleException;
    public String getEnrollmentStatusCode(Person person)throws RuleException;
    public String getResultReceivedPrimaryEligibilityCode();
    
	public boolean isVOASpinalCordIndicatorYes();

	
	//CCR7446
	public void cancelVOAPendingClock() throws RuleException;
	public void updateVOAPendingClock() throws RuleException;
	public boolean hasVOAPendingClockExpired();
	
	//CCR 7423
	public boolean isVoaHasAttachments();
	public void updateVoaAttachmentWithPersonId() throws RuleException;
	
	 public boolean isEnrollmentPriorityChanged() throws RuleException;
}