/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.rule;



// Java classes
import java.util.Date;
import java.util.Set;

// Library classes

// Framework classes

// ESR Classes
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.lookup.EmploymentStatus;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;

/**
 * This interface gets mapped to a virtual class in ILOG. The methods provide
 * access to the veteran's demographic data.
 * 
 * @author this was created by Wen Lin
 * @version 1.0
 */
public interface EmploymentInput extends BaseInput {
	// START CCR 10535 - Spouse Employment is broken
	public String getEmploymentStatusCode(Employment employment);
	public String getEmployerAddressLineOne(Employment employment);
	public void removeEmployerAddressLineOne(Employment employment);	
	// END CCR 10535 - Spouse Employment is broken
	
	public String getEmployerName();
	public String getPristineEmployerName();
	public EmploymentStatus getEmploymentStatus();
	public EmploymentStatus getPristineEmploymentStatus(); 
	public Address getEmployerAddress();
	public Address getPristineEmployerAddress();
	// CCR 10673
	public ImpreciseDate getRetirementDate();
	public ImpreciseDate getPristineRetirementDate();
	
	public Employment getEmployment();
	public Employment getResultEmployment();
	public Employment getPristineEmployment();
	
	public String getEmployerAddressLineTwo();
	public String getEmployerAddressLineThree();
	public String getEmployerCity();
	public String getEmployerState();
	public String getEmployerZipCode();
	public String getEmployerZipPlus4();
	
	public String getEmployerName(Employment employment);
	public EmploymentStatus getEmploymentStatus(Employment employment); 
	public Address getEmployerAddress(Employment employment);
	public ImpreciseDate getRetirementDate(Employment employment);
	
	public String getEmployerAddressLineTwo(Employment employment);
	public String getEmployerAddressLineThree(Employment employment);
	public String getEmployerCity(Employment employment);
	public String getEmployerState(Employment employment);
	public String getEmployerZipCode(Employment employment);
	public String getEmployerZipPlus4(Employment employment);
	
	public String getEmployerPhone(Employment employment);
	public String getPristineEmployerPhone();
	/*
	public void setEmployerAddressLineTwo();
	public void setEmployerAddressLineThree();
	public void setEmployerCity();
	public void setEmployerState();
	public void setEmployerZipCode();
	public void setEmployerZipPlus4();
	public void setEmployerPhone();
	*/
	public void setEmployerAddressLineTwo(Employment result, Employment incoming);
	public void setEmployerAddressLineThree(Employment result, Employment incoming);
	public void setEmployerCity(Employment result, Employment incoming);
	public void setEmployerState(Employment result, Employment incoming);
	public void setEmployerZipCode(Employment result, Employment incoming);
	public void setEmployerZipPlus4(Employment result, Employment incoming);
	public void setEmployerPhone(Employment result, Employment incoming);
	
	public void removeEmployment();
	public void removeDateOfRetirement();
	public void removeEmployerPhone();
	public void removeEmployerAddressLineTwo();
	public void removeEmployerAddressLineThree();
	public void removeEmployerCity();
	public void removeEmployerState();
	public void removeEmployerZipCode();
	public void removeEmployerZipPlus4();
	public void removeEmployment(Employment employment);
	public void removeDateOfRetirement(Employment employment);
	public void removeEmployerPhone(Employment employment);
	public void removeEmployerAddressLineTwo(Employment employment);
	public void removeEmployerAddressLineThree(Employment employment);
	public void removeEmployerCity(Employment employment);
	public void removeEmployerState(Employment employment);
	public void removeEmployerZipCode(Employment employment);
	public void removeEmployerZipPlus4(Employment employment);

	public boolean isAddressLineTwoNull(Employment employment);
	public boolean isEmploymentAddressGroupAllNull(Employment employment);
	public boolean isEmployerNameNotNull(Employment employment);
	public boolean isEmploymentStatusNotRetired(Employment employment);
	public boolean isEmploymentStatusUnknownOrNotEmployed();
	public boolean isEmploymentStatusUnknownOrNotEmployed(Employment employment);
	public boolean isEmployerNameNotEqualtoESREmployerName(Employment incomingEmployment, Employment pristineEmployment);
//	public boolean isEmploymentOnFile();
	public void acceptEmploymentForTheVeteran() ;
	public void addNewEmployment();
	public void acceptEmploymentForTheSpouse(Employment incoming, Employment result) ;
	public void addNewEmploymentForSpouse(Employment employment);
	public void updateEmployment( ) throws RuleException;
	public void updateEmployment(Employment updated, Employment incoming ) throws RuleException;
	public void deleteEmployerAddressGroup(Employment employment ) throws RuleException;
    public boolean isIncomingMessageHasOccupation(Employment incomingEmployment);
    public void setOccupation(Employment incomingEmployment, Employment pristineEmployment);
}