/*****************************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ****************************************************************************************/
package gov.va.med.esr.common.rule;

// Java classes
import java.util.Date;

// Library classes

// Framework classes
import gov.va.med.esr.common.model.person.Person;

import gov.va.med.fw.rule.RuleException;

// ESR classes
import gov.va.med.esr.common.infra.ImpreciseDate;

/**
 * @author Carlos Ruiz
 * @version 1.0
 */
public interface EligibilityVerificationInput extends BaseInput {

   public String getEligibilityVerificationSource() throws RuleException;
   public String getEligibilityVerificationSource(Person person) throws RuleException;
   public void setEligibilityVerificationSource(String code) throws RuleException;

   public ImpreciseDate getEligibilityStatusDate();
   public ImpreciseDate getEligibilityStatusDate(Person person);
   public void setEligibilityStatusDate(ImpreciseDate date);
   public void setEligibilityStatusDate(Date date);

   public String getEligibilityStatus() throws RuleException;
   public String getEligibilityStatus(Person person) throws RuleException;
   public void setEligibilityStatus(String status) throws RuleException;

   public String getEligibilityVerificationMethod();
   public String getEligibilityVerificationMethod(Person person);
   public void setEligibilityVerificationMethod(String method) throws RuleException;

   public String getQueryStatus();
   public String getQueryStatus( Person person );
   public void setQueryStatus(String Indicator) throws RuleException;

   public void setTriggeredEnrollmentProcess(boolean flag);
   public boolean getTriggerEnrollmentProcess();
   // CCR 11570
   public boolean hasQualifyingMse();
   public ImpreciseDate getMsdsMessageDate();
   
   public String getAACEntitlementCode();

   public String getMessageType();

   public String getUnsolicitedType();

   public String getSiteNumber() throws RuleException;

   public void setEligibilityVerificationFacility(String vaFacility) throws RuleException;
   public void acceptSiteEligibilityData(Person incoming, Person onFile) throws RuleException;
   
   // Accept only the Eligibility Verification data 
   public void acceptEligibilityVerificationData(Person incoming, Person onFile) throws RuleException;   
}