/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule;

// Java classes
import java.util.Date;

// Library classes

// Framework classes
import gov.va.med.fw.rule.RuleException;

/**
 * Project: Common
 * @author DNS   LEV
 * @version 1.0
 */
public interface EGTInput extends BaseInput {
	
   public boolean isNewEGTSetting();
   public String getEGTType() throws RuleException;
   public String getEGTPriorityGroup() throws RuleException;
   public Date getEGTEffectiveDate() throws RuleException;
   
   /**
    * Checks for an existing retroactive future EGT.
    */
   public boolean isRetroactiveFurureEGTSettingExists() throws RuleException;
   
   public void setEnrollmentSubPriority(String subPriority) throws RuleException;
   public void updateEGTRecord() throws RuleException;
   
   public String getCurrentEGTPriorityGroup() throws RuleException;
   public String getCurrentEGTPrioritySubGroup() throws RuleException;
   public Date getCurrentEGTEffectiveDate() throws RuleException;
   
   public boolean isCalcEnrPriorityGreaterThanEGT() throws RuleException;
   public boolean isCalcEnrPriorityLessThanEGT() throws RuleException;
   public boolean isCurrentEGTPriorityLessThan(String priority) throws RuleException;
   
   public Date getProcessEGTStartDate();
   
   public Date getPristineEGTEffectiveDate();
   public Date getEGTEffectiveStartDate();
   public boolean isRequestToTerminateEGTProcess();
   public void terminateEGTProcess();
   public void startEGTProcess();
   public void setEGTProcessStatus(String status);  
}
