/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule;

// Java classes
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author Carlos Ruiz
 * @author DNS   MANSOG
 * @author Ranga
 * @version 1.0
 */
public interface DependentFinancialInput extends FinancialInfoInput {
    
    public boolean isDemographicUpdate();

    public String getDependentGivenName();
    public String getDependentFamilyName();
    
	public Date getDependentBirthDate();
	
	public Date getDependentEffectiveDate();
	
	public Date getDependentInactiveDate();
	
    public Date getChildDependentEffective();	
    
    public String getDependentSSN();
    
    public boolean isDependentSSNUsed();
    
    public String getDependentRelationship();
    
    public boolean isDependentLivesWithVeteran();
    
    public boolean isChildSupportContributionIndicator();
    
    public BigDecimal getChildSupportContributionAmount();
    
    public Boolean getHasIncomeIndicator();
    public Boolean getIncomeAvailableToVeteranIndicator();
    
    public boolean isDependentHasAnyIncomeAmount();
    public boolean isDependentHasAnyExpenseAmount();
    public boolean isDependentHasAnyAssetAmount();
    
    public boolean isContributionInRange(double lower, double upper); 
   
    public int getTotalNumberOfDependents(); 
}

