/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.rule;



// Java classes
import java.util.Date;
import java.util.Set;

// Library classes

// Framework classes

// ESR Classes
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.PreferredFacility;
import gov.va.med.esr.service.external.demographics.DemographicsChangeType;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;

/**
 * This interface gets mapped to a virtual class in ILOG. The methods provide
 * access to the veteran's demographic data.
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public interface DemographicInput extends BaseInput {

	public Date getDateOfBirth();

	public Date getDateOfDeath();
	
	public Date getPreferredLanguageEntryDate();

	public boolean isDateInFuture(Date adate);

	public Date getDateOfDeathReported();

	public String getSSN();
    
	public String getPristineFirstName();

	public String getPristineLastName();

	public String getPristineMiddleName();

	public String getMiddleName();

	public String getSiteOfNotification();

	public String getPristineSiteOfNotification();

	public Date getPristineDateOfDeath();

	public boolean isDeathRecordDeleted();

	public String getSourceOfNotification();
    public void setSourceOfNotification(String deathSource);

	public boolean isDOBPlus15AfterMilitaryServiceServiceEntryDate();

	public boolean isDODBeforeMilitaryServiceServiceEntryDate();

	public boolean isDODBeforeMilitaryServiceServiceSeparationDate();

	public void removeDeathRecord() throws RuleException;

	public DeathRecord getDeathRecord();
	
	public void updateDeathRecord(DeathRecord deathRecord) throws RuleException;

	public void setDateOfDeathReported(Date date);

	public String getLastName();
	
	// CodeCR12890
	public String getNokLastName();	

	public String getFirstName();
	
	// CodeCR12890	
	public String getNokFirstName();
	
	// CodeCR12890 
	// Get the primary next of kin
	public Association getNextOfKin();

	public String getGenderCode();

	// Get the veteran's (pristine person) 15th birthday.
	public Date getDateOf15thBirthday();

	public String getDODReceivedFrom();

	public boolean isDateOfDeathUpdatedByVAMC();

	public String getPatientName();
    
	public VAFacility getCalculatedPreferredFacility();
	
    public Boolean getSensitiveIndicator();
    
    public Boolean getPristineSensitiveIndicator();
    
    public Date getSensitivityChangeDate();
    
    public Date getPristineSensitivityChangeDate();
    
    public void updateSensitivityInformation();
    
	/**
	 * This method updates the result person object with demographic data of
	 * incoming person.
	 * 
	 * @see MergeRuleService.mergeDemographic() method for more details.
	 */
	public void updateDemographicInformation();
    
    public void updateIdentityTraitsInformation();
    
    public void updateEmergencyResponseIndicator() throws RuleException;
	
	public DemographicsChangeType getRequestedChangeType();
	
	public String getNamePrefix();
	public String getPOAFirstName();
	public String getPOALastName();
	
	public String getPristineSSNVerificationStatus();
	public String getSSNVerificationStatus();
    
    public String getPseudoSSNReason();
    public String getPristinePseudoSSNReason();    
    
    public boolean hasInvalidSSNVerificationStatusForVetOrRelation(Person person) throws RuleException;
    public boolean hasPseudoSSNReasonOfFollowup() throws RuleException;    
    
    
    public Set findSitesOfRecord() throws ServiceException;
    
    public boolean isTreatingFacilityExist() throws ServiceException;
	public String getIDState() throws ServiceException;
	
	public boolean isRequestIDStateChangeError() throws ServiceException;

	public boolean isCreatePreferFacilityError() throws ServiceException;

	public boolean shouldIgnoreIncomingPreferredFacility() throws ServiceException;
	
	public boolean shouldIgnoreIncomingVOAPreferredFacility() throws ServiceException;
	
	public boolean shouldAddIncomingPreferredFacility() throws ServiceException;
	
	public boolean shouldAddIncomingVOAPreferredFacility() throws ServiceException;

	public boolean hasIncomingPreferredFacility();
	    
	public boolean hasResultPreferredFacility();

	public void addIncomingPreferredFacility(PreferredFacility facility, String sdCode) throws ServiceException;
	
	public void updatePreferredFacilityFromVistA(PreferredFacility facility) throws ServiceException;
	
	public void updatePreferredFacilityFromVOA(PreferredFacility facility) throws ServiceException;

	public PreferredFacility getPreferredFacility(); 

	public void setPreferredFacility(VAFacility facility) throws ServiceException;

	public void updatePreferredFacilitiesFromUI() throws ServiceException;
	
	public boolean isPreferredFacilityChanged() throws ServiceException;
	
	public String getPristineGenderCode();
	
	public boolean isVOAApplicantKnownToES();
	
	public boolean isMVIDODServiceActive() throws RuleException;
	
	public void setDoDModifiedBy();
	
	public boolean wasDODVerified();
	
	public boolean isDODVerified();
	
	public void restorePristineDeathRecord();
	
	public boolean isDateOfDeathUpdatedByMVI();
}
